#include <stdio.h>
#include <stdlib.h>

void PrintValues( short *array, short size );
int ShortCompare( const void *item1, const void *item2 );
short Search( short *array, short size, short key );
short BinarySearch( short *array, short size, short key );

short Values[] = { 838,791,316,181,730,315,600,849,358,447 };
short comparecount;  /* montako vertailua tehty */

typedef struct tagValueNode {
    short key;
    short order;
    struct tagValueNode *next;
} ValueNode;

typedef ValueNode *ValueNodePtr;

#define HASHPRIME 5
ValueNodePtr HashTable[ HASHPRIME ];  /* hajautustaulukko */

void PrintHashChains( void );
short HashFunc( short );
ValueNodePtr HashSearch( ValueNodePtr table[], short key );

void PrintResult( short found, short comparecount );

void PrintValues( short *array, short size )
{
    short i;
    for ( i = 0;  i < size;  i++ )
        printf( "%4d", array[i] );
    printf( "\n" );
}

int ShortCompare( const void *ptr1, const void *ptr2 )
{
    short item1, item2;

    comparecount++;

    item1 = *(short *)ptr1;
    item2 = *(short *)ptr2;

    if ( item1 < item2 )
        return -1;
    else if ( item1 > item2 )
        return 1;
    return 0;
}

short Search( short *array, short size, short key )
{
    short i;
    for ( i = 0;  i < size;  i++ )
    {
        if ( array[i] == key )
            return i;
        comparecount++;
    }
    return -1;
}

short BinarySearch( short *array, short size, short key )
{
    int low, high, mid, cmp;

    low = 0;
    high = size - 1;

    while ( low <= high )
    {
        mid = (low + high) / 2;
        cmp = ShortCompare( &key, &array[mid] );
        if ( cmp < 0 )
            high = mid - 1;
        else if ( cmp > 0 )
            low = mid + 1;
        else
            return mid;
    }
    return -1;
}

void PrintHashChains( void )
{
    short i;
    ValueNodePtr hashptr;

    for ( i = 0;  i < HASHPRIME;  i++ )
    {
        hashptr = HashTable[ i ];
        printf( "%d: ", i );
        while ( hashptr != NULL )
        {
            printf( "%d (%d) | ", hashptr->key, hashptr->order );
            hashptr = hashptr->next;
        }
        printf( "\n" );
    }
}

short HashFunc( short key )
{
    return key % HASHPRIME;
}

ValueNodePtr HashSearch( ValueNodePtr table[], short key )
{
    short hashvalue;
    ValueNodePtr hashptr;

    hashvalue = HashFunc( key );

    hashptr = table[hashvalue];
    while ( hashptr != NULL )
    {
        comparecount++;
        if ( hashptr->key == key )
            break;
        hashptr = hashptr->next;
    }
    return hashptr;  /* NULL jos ollaan ketjun pss tai se on tyhj */
}

void PrintResult( short found, short comparecount )
{
    printf( "%s. %d vertailua.\n",
        found ? "lytyi" : "ei lytynyt",
        comparecount );
}

int main( void )
{
    short size, key, i, found;
    void *ptr;
    ValueNodePtr valueptr;

    size = sizeof(Values) / sizeof(Values[0]);
    PrintValues( Values, size );

    for ( i = 0;  i < HASHPRIME;  i++ )
        HashTable[i] = NULL;

    printf( "Listn alkiot hajautustaulukkoon...\n" );
    for ( i = 0;  i < size;  i++ )
    {
        ValueNodePtr newvalue, hashptr;
        short hashvalue;

        newvalue = (ValueNodePtr) malloc( sizeof(ValueNode) );
        if ( !newvalue )
        {
            fprintf( stderr, "Muistin varaus eponnistui!\n" );
            exit( EXIT_FAILURE );
        }
        newvalue->key = Values[i];
        newvalue->order = i + 1;
        newvalue->next = NULL;

        hashvalue = HashFunc( Values[i] );
        hashptr = HashTable[ hashvalue ];
        if ( hashptr == NULL )
            HashTable[ hashvalue ] = newvalue;
        else
        {
            while ( hashptr->next != NULL )
                hashptr = hashptr->next;
            hashptr->next = newvalue;
        }
        printf( "%d: %d --> %d\n", i+1, Values[i], HashFunc(Values[i]) );
    }
    PrintHashChains();

    printf( "Lajitellaan taulukkoa...\n" );
    qsort( Values, size, sizeof(Values[0]), ShortCompare );
    PrintValues( Values, size );

    key = 730;
    printf( "Etsitn alkiota %d...\n", key );

    comparecount = 0;
    printf( "Hajautus: " );
    valueptr = HashSearch( &HashTable[0], key );
    found = (valueptr != NULL);
    PrintResult( found, comparecount );

    comparecount = 0;
    printf( "Perkkishaku: " );
    found = (Search( Values, size, key ) >= 0);
    PrintResult( found, comparecount );

    printf( "Binrihaku: " );
    comparecount = 0;
    found = (BinarySearch( Values, size, key ) >= 0);
    PrintResult( found, comparecount );

    /* HUOM! Ohjelma ei vapauta hajautusketjuille varattua muistia! */

    return 0;
}

