#include <dos.h>
#include <fcntl.h>
#include <io.h>

typedef unsigned char byte;
typedef unsigned int word;

char far *ajuri;	/* Ajurin osoite */
word versio;		/* Ajurin versio */
word status;		/* Tilasana */

int Voc_lataa_ajuri(void);
/* Lataa CT-VOICE.DRV-ajurin muistiin, kutsuttava aivan ensimmisen */
/* Palauttaa 0 jos ajuri ladattu oikein, 1 jos ajuria ei lydy ja */
/* 2 jos muistia ei ole tarpeeksi */
char far *Voc_lataa(char *tiedosto);
/* Lataa VOC-tiedoston muistiin ja palauttaa osoitteen siihen, kutsuttava */
/* ennen VOC:n soittoa. Palauttaa osoitteen jos kaikki on kunnossa, muuten */
/* palauttaa 0 */
void Voc_poista(char far *osoite);
/* Poistaa VOC-tiedoston muistista ja vapauttaa muistin. */

void Voc_versio(void);
/* Palauttaa ajurin versionumeron */
void Voc_portti(word portti);
/* Asettaa I/O-osoitteen (yleens 0x220), kutsuttava ennen Voc_init:i */
/* (ei tarvitse jos osoite on 220h) */
void Voc_DMA(word dma);
/* Asettaa DMA-kanavan (yleens 7), kutsuttava ennen Voc_init:i */
/* (ei tarvitse jos kanava on 7) */
void Voc_tilasana(void);
/* Asettaa tilasanan (word), joka kertoo, mit SB kulloinkin tekee. */
/* Kutsuttava ennen Voc_init:i. */

int Voc_init(void);
/* Initialisoi ajurin. Tt on kutsuttava ennen kuin seuraavia funktioita */
/* voidaan kytt */

void Voc_terminoi(void);
/* Terminoi ajurin, eli lopettaa kaikki toiminnot */
void Voc_kaiutin(word asento);
/* Knt kaiuttimen plle(1)/pois(0) */
int Voc_soita(byte far *osoite);
/* Aloittaa VOC:n soittamisen */
void Voc_lopeta(void);
/* Lopettaa VOC:n soittamisen */
int Voc_paussi(void);
/* Pysytt VOC:n soiton */
int Voc_jatka(void);
/* Jatkaa soittoa paussin jlkeen */
int Voc_looppi(void);
/* Lopettaa 'loopin', joka toistaa osaa VOC:sta uudelleen ja uudelleen */

int Voc_tee_kaikki(word portti,word dma);
/* Tm on pakettiratkaisu, joka lataa ajurin muistiin ja */
/* kutsuu funktioita Voc_versio, Voc_portti, Voc_DMA, Voc_tilasana */
/* ja Voc_init. Palauttaa 0 jos kaikki meni hyvin. */

