#include <dos.h>
#include <io.h>
#include <stdio.h>
#include <fcntl.h>

char far *ajuri, /* CT-VOICE.DRV:n osoite */
                    far *data,  /* VOC-tiedoston osoite */
                    far *temp;  /* Vliaikainen osoitin */
int status;    /* Tilasana, ei kytss tss ohjelmassa */

int main(int argc,char *argv[]) {
	int handle; /* Tiedoston handle */
	unsigned int para,segm,offs,bytes;
	if (argc!=2) {
		fprintf(stdout,"\nKytt: SOUND vocfile\n");
		return(1);
	}  /* Avataan CT-VOICE.DRV */
	if (_dos_open("CT-VOICE.DRV",O_RDONLY,&handle)) {
		fprintf(stdout,"\nCT-VOICE.DRV ei lydy\n");
		return(3);
	}
	/* Muistia tarvitaan koko/16+1 paragraphia */
	para=1+(filelength(handle)/16);
	if (_dos_allocmem(para,&segm)) {
		fprintf(stdout,"\nEi tarpeeksi muistia ajurille\n");
		return(3);
	}
	/* Varatun alueen segmentti talletetaan ajuri-muuttujaan, */
	/*  alue on segmentin alussa, eli offsetti ei ole */
	ajuri=(char far *)MK_FP(segm,0);

	fprintf(stdout,"\nLadataan ajuri muistiin...");
	temp=ajuri;
	do {	/* Tiedoston luku: bytes==luettu mr */
		_dos_read(handle,temp,0x200,&bytes);
		temp+=bytes;	/* Siirretn osoitinta */
	} while(bytes==0x200);	/* Lopetetaan kun kaikki on luettu */
	_dos_close(handle);

	/* Sama juttu VOC-tiedostolle */
	if (_dos_open(argv[1],O_RDONLY,&handle)) {
		fprintf(stdout,"\n%s ei lydy\n",argv[1]);
		return(3);
	}
	para=1+(filelength(handle)/16);
	if (_dos_allocmem(para,&segm)) {
		fprintf(stdout,"\nEi tarpeeksi muistia nitiedolle\n");
		return(3);
	}
	data=(char far *)MK_FP(segm,0);
	fprintf(stdout,"\nLadataan %s muistiin...",argv[1]);
	temp=data;
	do {
		_dos_read(handle,temp,0x200,&bytes);
		temp+=bytes;
	} while(bytes==0x200);	/* bytes!=0x200 kun tiedosto */
	_dos_close(handle);		/* on luettu loppuun */

	fprintf(stdout,"\nAlustetaan ajuri...");
	asm {
		mov bx,2
		mov ax,1
		call ajuri
		mov bx,3
		call ajuri  /* Ajurin alustus */
		mov bx,0
		call ajuri  /* Versionumeron haku */
		mov bytes,ax  /* Kytetn bytes:i vliaikaisesti */
	}
	fprintf(stdout,"versio %u.%u lydetty\n"
		"Asetetaan tilasana...",bytes/256,bytes%256);
	segm=FP_SEG(&status);	/* pilkotaan status-word */
	offs=FP_OFF(&status);	/* segmentiksi ja offsetiksi */
	asm {
		mov bx,5
		mov es,segm
		mov di,offs
		call ajuri
	}

	fprintf(stdout,"\nSoitetaan ni...");
	segm=FP_SEG(data);
	/* Tiedoston 20. tavu kertoo, mist kohtaa tiedostoa */
	/*  itse nitieto alkaa. */
	offs=FP_OFF(data)+data[20];
	asm {
		mov bx,6
		mov es,segm
		mov di,offs
		call ajuri
	}
	/* ni soi taustalla - tss voi kirjoitella teksti */
	/*  ennen enterin painamista */
	fprintf(stdout,"\nPaina enteri kun haluat lopettaa.\n");
	getc(stdin);
	asm {    /*/ Suljetaan ajuri */
		mov bx,9
		call ajuri
	}
	fprintf(stdout,"\nValmis!");
	_dos_freemem(FP_SEG(ajuri));
	_dos_freemem(FP_SEG(data));
	return(0);
}