/*
 * ATALEVY.C -- ATA-kiintolevyjen tunnistus
 * Borland C++ 3.1: knn komennolla 'bcc atalevy.c'
 */

#include <stdio.h>
#include <dos.h>
#include <string.h>
#include "ata.h"

int QueryDriveInfo( void );
BOOL QueryATAInfo( int nDrives );
char *GetBufferString( WORD awBuf[], int iStart, int iEnd );
int CheckForWindowsOrDesqview( void );

int gnDrives;						/* kiintolevyjen lukumr */
HDDINFO gHDDInfo[2];				/* kiintolevyjen tiedot */

#define ATA gHDDInfo[i].AtaInfo		/* lyhennysmerkint */

int main( void )
{
    int i;

    i = CheckForWindowsOrDesqview();
    if ( i != 0 )
    {
    	switch ( i )
        {
        	case 1:
			case 2:
				fprintf( stderr, "Microsoft Windows");
                break;
            case 3:
            	fprintf( stderr, "DESQview" );
                break;
            default:
            	break;
        }
		fprintf( stderr, " on kynniss. Tt ohjelmaa voi kytt vain MS-DOSista.\n" );
        return -1;
    }

    gnDrives = QueryDriveInfo();
    if ( !QueryATAInfo( gnDrives ) )
	{
    	printf( "Virhe luettaessa tietoja levylt\n" );
		return -1;
    }
    for ( i = 0;  i < gnDrives;  ++i )
    {
        printf( "*** LEVY %d ***\n", i );
        printf( "Mallitieto....: %s\n", ATA.szModel );
        printf( "Sarjanumero...: %s\n", ATA.szSerial );
        printf( "Revisio.......: %s\n", ATA.szRevision );
        printf( "Vlimuisti....: %ld kt\n",
                ATA.dwBufferSize / KILOBYTE );
        printf( "Kapasiteetti..: %ld Mt\n",
                ATA.dwCapacity / (KILOBYTE * KILOBYTE) );
        printf( "BIOS-tiedot...: %d / %d / %d (tyyppi %d)\n",
                gHDDInfo[i].BiosCHS.cyl,
                gHDDInfo[i].BiosCHS.hd,
                gHDDInfo[i].BiosCHS.sec,
				(short) gHDDInfo[i].bBiosType );
        printf( "Levyn tiedot..: %d / %d / %d\n",
                ATA.chs.cyl, ATA.chs.hd, ATA.chs.sec );
        printf( "\n" );
    }
    return 0;
}

int QueryDriveInfo( void )
{
    int nDrives, i; /* kiintolevyjen lukumr (0 tai 1) */
    union REGS r;   /* rekisterit BIOS-kutsuja varten */
    BYTE bBiosType; /* BIOSin antama kiintolevytyyppi */

    /* hae CMOS-muistista tavu johon on koodattu */
    /* kiintolevyjen BIOS-tyypit */
    outportb( CMOS_OUT, 0x12 );
    bBiosType = inportb( CMOS_IN );

    nDrives = peekb( BIOS_DATA_SEG, BIOS_NUM_HDD );
    for ( i = 0;  i < nDrives;  ++i )
    {
    	gHDDInfo[i].bBiosType = (i == 0) ? (bBiosType & 0xf0) >> 4 : (bBiosType & 0x0f);
		/* 0x0f = laajennettu tyyppi; haettava varsinainen */
		if ( gHDDInfo[i].bBiosType == 0x0f )
		{
			outportb( CMOS_OUT, 0x19 + i );
			gHDDInfo[i].bBiosType = inportb( CMOS_IN );
		}

        r.h.ah = 0x08;              /* INT 13h, funktio 08h */
        r.h.dl = 0x80 + i;          /* levyn numero (0/1) */
        int86( DISK_INTR, &r, &r );
        if ( !r.x.cflag )
        {
            gHDDInfo[i].BiosCHS.cyl = ((r.h.cl & 0xC0) << 2) + r.h.ch + 2;
            gHDDInfo[i].BiosCHS.hd  = r.h.dh + 1;
            gHDDInfo[i].BiosCHS.sec = r.h.cl & 0x3f;
        }
        else return 0;
    }
    return nDrives;
}

BOOL QueryATAInfo( int nDrives )
{
    int i;
    WORD awBuf[256], wOffset;
    BYTE bStatus;
    long lTimeOut = TIMEOUT;

    for ( i = 0;  i < nDrives;  ++i )
    {
        do
        	bStatus = inportb( TF_STATUS );
        while ( (bStatus != (DRDY | SKC)) && --lTimeOut );
        if ( lTimeOut <= 0 ) return FALSE;

        /* A0h = levy 0, B0h = levy 1 */
        outportb( TF_DRIVE_HEAD, (i == 0) ? 0xA0 : 0xB0 );
        outportb( TF_COMMAND, CMD_IDENTIFY_DRIVE );
        lTimeOut = TIMEOUT;
        do
        	bStatus = inportb( TF_STATUS );
        while ( (bStatus != (DRDY | SKC | DRQ)) && --lTimeOut );
        if ( lTimeOut <= 0 ) return FALSE;

        for ( wOffset = 0;  wOffset != 256;  wOffset++ )
            awBuf[wOffset] = inport( TF_DATA );

        strcpy( ATA.szModel,    GetBufferString( awBuf, 27, 46 ) );
        strcpy( ATA.szSerial,   GetBufferString( awBuf, 10, 19 ) );
        strcpy( ATA.szRevision, GetBufferString( awBuf, 23, 26 ) );
        ATA.dwBufferSize = awBuf[21] * (DWORD)SECTOR_SIZE;
        ATA.chs.cyl = awBuf[1];
        ATA.chs.hd  = awBuf[3];
        ATA.chs.sec = awBuf[6];
        ATA.dwCapacity = (DWORD)ATA.chs.cyl * (DWORD)ATA.chs.hd
			* (DWORD)ATA.chs.sec * (DWORD)SECTOR_SIZE;
    }
    return TRUE;
}

char *GetBufferString( WORD awBuf[], int iStart, int iEnd )
{
    static char szReturn[128];
    int i, iBufPtr;
    BYTE bHigh, bLow;

    iBufPtr = 0;
    for ( i = iStart;  i <= iEnd;  ++i )
    {
        bHigh = awBuf[i] / 256;  /* sanan enemmn merkitsev tavu */
        bLow  = awBuf[i] % 256;  /* sanan vhemmn merkitsev tavu */
        szReturn[iBufPtr] = (char) bHigh;  iBufPtr++;
        szReturn[iBufPtr] = (char) bLow;   iBufPtr++;
    }
    szReturn[iBufPtr] = '\0';   /* pt merkkijono */
    return szReturn;            /* palauta osoitin */
}

/*
 * CheckForWindowsOrDesqview()
 * Tarkista onko Microsoft Windows tai DESQview kynniss.
 * Palauttaa:
 * 		0 = ei kumpaakaan kynniss
 *		1 = Windows 386-tilassa
 *		2 = Windows vakiotilassa
 *		3 = DESQview kynniss
 */
int CheckForWindowsOrDesqview( void )
{
        int retval = 0;

        asm {
                mov     ax,4680h
                int     2fh
                mov     word ptr retval,1
                or      ax,ax
                jz      CheckOut
                mov     ax,1600h
                int     2fh
                mov     word ptr retval,2
                or      al,al
                jz      CheckDV
                cmp     al,80h
                jnz     CheckOut
        }
CheckDV:
        asm {
                mov     ax,1022h
                mov     bx,0
                int     15h
                mov     word ptr retval,3
                cmp     bx,0a01h
                jz      CheckOut
                mov     word ptr retval,0
        }
CheckOut:
        return retval;
}
