typedef enum { FALSE, TRUE } BOOL;
typedef unsigned int WORD;
typedef unsigned char BYTE;
typedef unsigned long DWORD;

typedef struct tagCHSINFO {
	WORD cyl, hd, sec;
} CHSINFO;

typedef struct tagATAINFO {
	char szModel[64];
    char szSerial[32];
    char szRevision[16];
	DWORD dwBufferSize;
	DWORD dwCapacity;
    CHSINFO chs;
} ATAINFO;

typedef struct tagHDDINFO {
    CHSINFO BiosCHS;
    ATAINFO AtaInfo;
    BYTE bBiosType;
} HDDINFO;

#define BIOS_DATA_SEG   0x0040	/* BIOSin datasegmentti */
#define BIOS_NUM_HDD    0x75	/* kiintolevyjen lkm:n osoite */

#define DISK_INTR       0x13	/* levytoimintojen keskeytys */
#define SECTOR_SIZE     512		/* kiintolevyn sektorin koko */
#define KILOBYTE        1024L	/* arvaa mik? */
#define TIMEOUT		 1000000L	/* odotteluaika */

#define CMOS_OUT    0x70	/* CMOS-muistin kirjoitusportti */
#define CMOS_IN     0x71	/* CMOS-muistin lukuportti */


/* ATA Task File (TF) registers */
#define TF_DATA       0x1F0   /* data register            */
#define TF_DRIVE_HEAD 0x1F6   /* drive/head register      */
#define TF_STATUS     0x1F7   /* status register (read)   */
#define TF_COMMAND    0x1F7   /* command register (write) */

/* Drive state flags for Status Register */
#define BSY    0x80    /* busy                */
#define DRDY   0x40    /* drive ready         */
#define DF     0x20    /* write fault         */
#define SKC    0x10    /* seek complete       */
#define DRQ    0x08    /* data request        */
#define CORR   0x04    /* corrected data      */
#define INX    0x02    /* index               */
#define ERR    0x01    /* unrecoverable error */

/* Command codes for Command Register */
#define CMD_IDENTIFY_DRIVE  0xEC
