/*
** Copyright (C) 1999 Juhan Aslak Nkkljrvi <j.aslak@kolumbus.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <libintl.h>

#define _(HiH) (gettext (HiH))

#include <stddef.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/un.h>

#include "version.h"
#include "command.h"
#include "wmode.h"

#define SERVER  "/tmp/led_socket"
#define CLIENT  "/tmp/client_socket"

struct command
{
	int cmd;
	int arg_len;
	char *arg;
};

struct command cmd={ 0, 0, NULL };
int quiet=0;

int AddCommand(int c,int n,char* a)
{
	cmd.cmd=c;
	cmd.arg_len=n;
	if (cmd.arg)
		free(cmd.arg);
	cmd.arg=(char *)malloc(n*sizeof(char));
	memcpy(cmd.arg,a,n);
}

int WriteInt(int a,char* b)
{
	memcpy(b,&a,sizeof(a));
	return sizeof(int);
}

int make_named_socket(char* filename)
{
	struct sockaddr_un name;
	int sock;
	size_t size;

	sock=socket(PF_UNIX,SOCK_DGRAM,0);
	if (sock<0)
	{
		perror("socket");
		return 1;
	}
	name.sun_family=AF_UNIX;
	strcpy(name.sun_path,filename);

	size = (offsetof (struct sockaddr_un, sun_path) + strlen (name.sun_path) + 1);

	if (bind(sock,(struct sockaddr *)&name,size)<0)
	{
		perror("bind");
		exit(1);
	}
	return sock;
}

int AddGauge(struct WMode* a,int num)
{
	struct Gauge** t;
	int k;
	
	if (num < a->gauge_num)
		return 0;
	if (num > a->gauge_num)
		return 1;
	
	t=(struct Gauge **)malloc((num+1)*sizeof(struct Gauge *));
	for (k=0;k < a->gauge_num;k++)
		t[k]=a->gauge[k];
	t[k]=(struct Gauge *)malloc(sizeof(struct Gauge));
	t[k]->modenum=0;
	t[k]->mode=NULL;
	t[k]->size=0;
	t[k]->position=NULL;
	if (a->gauge)
		free(a->gauge);
	a->gauge=t;
	a->gauge_num=num+1;
	return 0;
}

int HandleWMode(struct WMode* w,int n)
{
	int k,i;
	char *buff;
	int p=0;
	int t;
	
	buff=(char *)malloc(1000*sizeof(char));
	
	t=WriteInt(n,buff+p);p+=t;
	t=WriteInt(w->gauge_num,buff+p);p+=t;
	
	for (k=0;k < w->gauge_num;k++)
	{
		t=WriteInt(w->gauge[k]->modenum,buff+p);p+=t;
		for (i=0;i< w->gauge[k]->modenum;i++)
		{
			t=WriteInt(w->gauge[k]->mode[i],buff+p);
			p+=t;
		}
		t=WriteInt(w->gauge[k]->size,buff+p);p+=t;
		for (i=0;i< w->gauge[k]->size;i++)
		{
			t=WriteInt(w->gauge[k]->position[i],buff+p);
			p+=t;
		}
	}
	AddCommand(CMD_DEFWMODE,p,buff);
	return 0;
}

int HandleArgs(int argc,char *argv[])
{
	int p,tp;
	int t,r;
	int k,i;
	int set_wmode=-1;
	int set_gauge=-1;
	struct WMode a;
	char *buff,*tok;
	char *ts;
	char *reqarg=_("Option %s requires an argument!\n");
	char *nowg=_("Working mode (yeah, sure) or gauge not set!\n");
	
	a.gauge_num=0;
	a.gauge=0;
	
	for (p=1;p<argc;p++)
		if (argv[p][0]=='-')
			if (argv[p][1]=='h' || !strcmp(argv[p]+1,"-help"))
			{
				printf(
_("%s %d.%d.%d %s client\n"
"\n"
"Controls LED server's behaviour.\n"
"\n"
"Options:\n"
"\n"
"  -d, --define-wmode WMODE      Sets the target working mode WMODE.\n"
"  -g, --gauge GAUGE             Sets the target gauge GAUGE for current target wmode\n"
"                                (creates new one if gauge doesn't exist).\n"
"  -m, --mode MODE               Sets gauge mode MODE for current target gauge.\n"
"  -p, --position LIST           Sets the position array for current target gauge.\n"
"      --off                     Turns LED off.\n"
"      --on                      Turns LED on.\n"
"  -w, --working-mode MODE       Sets the working mode to MODE.\n"
"  -l, --list-modes              Lists the working modes.\n"
"  -x, --xor XOR                 Sets the xor status to XOR.\n"
"  -D, --delay DELAY             Sets the LEDbox update interval.\n"
"  -q, --quiet                   Quiet, don't echo this and that.\n"
"\n"
"  -h, --help                    Displays this help.\n"
"  -v, --version                 Displays the version.\n"
"\n"
"Mail bugs, comments, whatever to %s\n")
,PROG_NAME,MAJOR_VER,MINOR_VER,REV_VER,VER_NOTE,argv[0],"j.aslak@kolumbus.fi");	// Some silly translator might change it by accident, typoking et cetera  :)
				return 1;
			}
			else if (argv[p][1]=='v' || !strcmp(argv[p]+1,"-version"))
			{
				printf(
_("%s version %d.%d.%d %s - client\n"),PROG_NAME,MAJOR_VER,MINOR_VER,REV_VER,VER_NOTE);
				return 1;
			}
			else if (argv[p][1]=='w' || !strcmp(argv[p]+1,"-working-mode"))
			{
				p++;
				if (p>=argc)
				{
					fprintf(stderr,reqarg,"-w");
					return 1;
				}
				ts=(char *)malloc(sizeof(int));
				WriteInt(strtol(argv[p],NULL,0),ts);
				AddCommand(CMD_WMODE,sizeof(int),ts);
				free(ts);
			}
			else if (argv[p][1]=='q' || !strcmp(argv[p]+1,"-quiet"))
				quiet=1;
			else if (argv[p][1]=='l' || !strcmp(argv[p]+1,"-list-modes"))
				AddCommand(CMD_LISTWMODES,0,NULL);
			else if (!strcmp(argv[p]+1,"-on"))
				AddCommand(CMD_ON,0,NULL);
			else if (!strcmp(argv[p]+1,"-off"))
				AddCommand(CMD_OFF,0,NULL);
			else if (argv[p][1]=='x' || !strcmp(argv[p]+1,"-xor"))
			{
				p++;
				if (p>=argc)
				{
					fprintf(stderr,reqarg,"-x");
					return 1;
				}
				ts=(char *)malloc(sizeof(int));
				WriteInt(strtol(argv[p],NULL,0),ts);
				AddCommand(CMD_XOR,sizeof(int),ts);
				free(ts);
			}
			else if (argv[p][1]=='D' || !strcmp(argv[p]+1,"-delay"))
			{
				p++;
				if (p>=argc)
				{
					fprintf(stderr,reqarg,"-D");
					return 1;
				}
				ts=(char *)malloc(sizeof(int));
				WriteInt(strtol(argv[p],NULL,0),ts);
				AddCommand(CMD_DELAY,sizeof(int),ts);
				free(ts);
			}
			else if (argv[p][1]=='d' || !strcmp(argv[p]+1,"-define-wmode"))
			{
				p++;
				if (p>=argc)
				{
					fprintf(stderr,reqarg,"-d");
					return 1;
				}
				if (set_wmode!=-1)
				{
					fprintf(stderr,_("No multiple calls to -d allowed!\n"));
					return 1;
				}
				set_wmode=strtol(argv[p],NULL,0);
			}
			else if (argv[p][1]=='g' || !strcmp(argv[p]+1,"-gauge"))
			{
				p++;
				if (p>=argc)
				{
					fprintf(stderr,reqarg,"-g");
					return 1;
				}
				if (set_wmode==-1)
				{
					fprintf(stderr,_("Trying to set gauge and no working mode set!\n"));
					return 1;
				}
				set_gauge=strtol(argv[p],NULL,0);
				if (AddGauge(&a,set_gauge))
				{
					fprintf(stderr,_("Too big gauge number `%d'!\n"),set_gauge);
					return 1;
				}
			}
			else if (argv[p][1]=='m' || !strcmp(argv[p]+1,"-mode"))
			{
				if (set_wmode==-1 || set_gauge==-1)
				{
					fprintf(stderr,nowg);
					return 1;
				}
				p++;
				if (p>=argc)
				{
					fprintf(stderr,reqarg,"-m");
					return 1;
				}
				buff=(char *)malloc((strlen(argv[p])+1)*sizeof(char));
				strcpy(buff,argv[p]);

				tok=strtok(buff," ,:");
				tp=0;
				do { tp++; } while ((tok=strtok(NULL," ,:")));
				a.gauge[set_gauge]->modenum=tp;
				a.gauge[set_gauge]->mode=(int *)malloc(a.gauge[set_gauge]->size*sizeof(int));
				
				strcpy(buff,argv[p]);
				tok=strtok(buff," ,:");
				tp=0;
				do
				{
					a.gauge[set_gauge]->mode[tp]=strtol(tok,NULL,0);
					tp++;
				} while ((tok=strtok(NULL," ,:"))!=NULL);
			}
			else if (argv[p][1]=='p' || !strcmp(argv[p]+1,"-position"))
			{
				if (set_wmode==-1 || set_gauge==-1)
				{
					fprintf(stderr,nowg);
					return 1;
				}
				p++;
				if (p>=argc)
				{
					fprintf(stderr,reqarg,"-p");
					return 1;
				}
				buff=(char *)malloc((strlen(argv[p])+1)*sizeof(char));
				strcpy(buff,argv[p]);

				tok=strtok(buff," ,:");
				tp=0;
				do { tp++; } while ((tok=strtok(NULL," ,:")));
				a.gauge[set_gauge]->size=tp;
				a.gauge[set_gauge]->position=(int *)malloc(a.gauge[set_gauge]->size*sizeof(int));
				
				strcpy(buff,argv[p]);
				tok=strtok(buff," ,:");
				tp=0;
				do
				{
					a.gauge[set_gauge]->position[tp]=strtol(tok,NULL,0);
					tp++;
				} while ((tok=strtok(NULL," ,:"))!=NULL);
			}
	if (set_wmode!=-1)
	{
		for (k=0;k<a.gauge_num;k++)
		{
			if (!a.gauge[k]->mode)
			{
				fprintf(stderr,_("No working mode set for gauge %d in working mode %d!\n"),k,set_wmode);
				return 1;
			}
			if (!a.gauge[k]->position)
			{
				fprintf(stderr,"No position array set for gauge %d in working mode %d!\n",k,set_wmode);
				return 1;
			}
		}
		if (!quiet)
		{
			printf(
				_("Working mode %d to be defined as:\n"
				  "\n"),set_wmode);
			printf(
				a.gauge_num==1 ?
				_( "%d gauge\n"
				   "\n") :
				_("%d gauges\n"
				  "\n"),a.gauge_num);
			for (k=0;k<a.gauge_num;k++)
			{
				printf(_(
					"Gauge %d:\n"
					"Gauge mode:"),k);
				for (i=0;i<a.gauge[k]->modenum;i++)
					printf(" %d",a.gauge[k]->mode[i]);
				printf("\n");
				printf(
					_("Gauge size %d\n"
					  "Gauge positioning:"),a.gauge[k]->size);
				for (i=0;i<a.gauge[k]->size;i++)
					printf(" %d",a.gauge[k]->position[i]);
				printf("\n\n");
			}
		}
		if (r=HandleWMode(&a,set_wmode))
			return r;
	}
	return 0;
}

int main(int argc,char *argv[])
{
	int sock;
	char msg[400];
	int msg_len;
	struct sockaddr_un name;
	size_t size;
	int nbytes;
	int k;
	int r;
	char *tok;
	
	setlocale (LC_ALL, "");
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);
	
	if (argc==1)
	{
		printf(
_("%s %d.%d.%d %s - client\n"
"Try %s --help for help.\n")
,PROG_NAME,MAJOR_VER,MINOR_VER,REV_VER,VER_NOTE,argv[0]);
		return 1;
	}
	else
		if (r=HandleArgs(argc,argv))
			return r;
	
	if (cmd.cmd==CMD_NONE)
	{
		printf(_("Nothing done.\n"));
		return;
	}
	
	sock = make_named_socket (CLIENT);
	name.sun_family = AF_UNIX;
	strcpy (name.sun_path, SERVER);
	size = strlen (name.sun_path) + sizeof (name.sun_family);

	msg_len=0;
	msg_len+=WriteInt(cmd.cmd,msg);
	for (k=0;k<cmd.arg_len;k++)
		msg[msg_len++]=cmd.arg[k];
	
	/* Send the datagram. */
	nbytes = sendto (sock, msg, msg_len, 0,
	                 (struct sockaddr *) & name, size);
	if (nbytes < 0)
	{
		perror ("sendto (client)");
		exit (EXIT_FAILURE);
	}
	if (!quiet)
		printf(_("Sent %d bytes.\n"),msg_len);

	nbytes = recvfrom (sock, msg, 400, 0, NULL, 0);
	
	k=0;
	do
	{
		tok=msg+k;
		for  (;msg[k]!='\n' && msg[k]!='\0';k++);
		msg[k++]='\0';
		if (!quiet)
			printf(_("Server says: %s\n"),tok);
		if (msg[k]=='\0')
			break;
	} while (1);
	
	if (nbytes < 0)
	{
		perror ("recfrom (client)");
		exit (EXIT_FAILURE);
	}

	remove (CLIENT);
	close (sock);
}


