/*
 * Decompiled with CFR 0.152.
 */
package netscape.debug;

import netscape.debug.InvalidInfoException;
import netscape.debug.StackFrameInfo;
import netscape.debug.ThreadHook;

public class ThreadState {
    private Thread thread;
    private boolean valid;
    private boolean runningHook;
    private boolean resumeWhenDone;
    private int status;
    private int continueState;
    StackFrameInfo[] stack;
    private Object returnValue;
    private Throwable currentException;
    private ThreadHook savedHook;
    private int currentFramePtr;
    private ThreadState previous;
    public static final int THR_STATUS_UNKNOWN = 1;
    public static final int THR_STATUS_ZOMBIE = 2;
    public static final int THR_STATUS_RUNNING = 3;
    public static final int THR_STATUS_SLEEPING = 4;
    public static final int THR_STATUS_MONWAIT = 5;
    public static final int THR_STATUS_CONDWAIT = 6;
    public static final int THR_STATUS_SUSPENDED = 7;
    public static final int THR_STATUS_BREAK = 8;
    public static final int DEBUG_STATE_DEAD = 1;
    public static final int DEBUG_STATE_RUN = 2;
    public static final int DEBUG_STATE_RETURN = 3;
    public static final int DEBUG_STATE_THROW = 4;

    public static native ThreadState getThreadState(Thread var0) throws InvalidInfoException;

    public Thread getThread() {
        return this.thread;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isRunningHook() {
        return this.runningHook;
    }

    public int getStatus() {
        return this.status;
    }

    public native int countStackFrames() throws InvalidInfoException;

    public native StackFrameInfo getCurrentFrame() throws InvalidInfoException;

    public synchronized StackFrameInfo[] getStack() throws InvalidInfoException {
        StackFrameInfo stackFrameInfo;
        if (this.stack == null) {
            this.stack = new StackFrameInfo[this.countStackFrames()];
        }
        if (this.stack.length == 0) {
            return this.stack;
        }
        this.stack[this.stack.length - 1] = stackFrameInfo = this.getCurrentFrame();
        int n = this.stack.length - 2;
        while (n >= 0) {
            this.stack[n] = stackFrameInfo = stackFrameInfo.getCaller();
            --n;
        }
        return this.stack;
    }

    public void leaveSuspended() {
        this.resumeWhenDone = false;
    }

    public synchronized void resume() {
        if (this.runningHook) {
            this.resumeWhenDone = true;
            return;
        }
        this.resume0();
    }

    private native void resume0();

    public int getContinueState() {
        return this.continueState;
    }

    public Object getReturnValue() throws IllegalStateException {
        if (this.continueState != 3) {
            throw new IllegalStateException("no value being returned");
        }
        return this.returnValue;
    }

    public Throwable getException() throws IllegalStateException {
        if (this.continueState != 4) {
            throw new IllegalStateException("no exception throw in progress");
        }
        return this.currentException;
    }

    public void setThreadHook(ThreadHook threadHook) {
        this.savedHook = threadHook;
    }

    public ThreadHook getThreadHook() {
        return this.savedHook;
    }
}

