/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

class ZipFileInputStream
extends InputStream
implements ZipConstants {
    private ZipFile zf;
    private ZipEntry ze;
    private long pos;
    private long count;

    ZipFileInputStream(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.zf = zipFile;
        this.ze = zipEntry;
        this.readLOC();
    }

    public int available() {
        return (int)Math.min(this.count, Integer.MAX_VALUE);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.count == 0L) {
            return -1;
        }
        if ((long)n2 > this.count) {
            n2 = (int)Math.min(this.count, Integer.MAX_VALUE);
        }
        if ((n2 = this.zf.read(this.pos, byArray, n, n2)) == -1) {
            throw new ZipException("premature EOF");
        }
        this.pos += (long)n2;
        this.count -= (long)n2;
        return n2;
    }

    public int read() throws IOException {
        if (this.count == 0L) {
            return -1;
        }
        int n = this.zf.read(this.pos);
        if (n == -1) {
            throw new ZipException("premature EOF");
        }
        ++this.pos;
        --this.count;
        return n;
    }

    public long skip(long l) {
        if (l > this.count) {
            l = this.count;
        }
        this.pos += l;
        this.count -= l;
        return l;
    }

    private void readLOC() throws IOException {
        byte[] byArray = new byte[30];
        this.zf.read(this.ze.offset, byArray, 0, 30);
        if (ZipFile.get32(byArray, 0) != 67324752L) {
            throw new ZipException("invalid LOC header signature");
        }
        this.count = this.ze.csize;
        this.pos = this.ze.offset + 30L + (long)ZipFile.get16(byArray, 26) + (long)ZipFile.get16(byArray, 28);
        if (this.pos + this.count > this.zf.cenpos) {
            throw new ZipException("invalid LOC header format");
        }
    }
}

