/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import netscape.ldap.LDAPException;

class LDAPSSLavaSocket
extends Socket {
    private final boolean m_debug = true;
    private Object m_socket;
    private final String m_packageName = "crysec.SSL.SSLSocket";
    private Hashtable m_methodLookup = new Hashtable();

    public LDAPSSLavaSocket(String string, int n) throws LDAPException {
        try {
            Class<?> clazz = Class.forName("crysec.SSL.SSLSocket");
            Constructor<?>[] constructorArray = clazz.getConstructors();
            int n2 = 0;
            while (n2 < constructorArray.length) {
                Class<?>[] classArray = constructorArray[n2].getParameterTypes();
                if (classArray.length == 2 && classArray[0].getName().equals("java.lang.String") && classArray[1].getName().equals("int")) {
                    Object[] objectArray = new Object[]{string, new Integer(n)};
                    this.m_socket = constructorArray[n2].newInstance(objectArray);
                    return;
                }
                ++n2;
            }
            throw new LDAPException("No appropriate constructor in crysec.SSL.SSLSocket", 89);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("Class crysec.SSL.SSLSocket not found", 80);
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to create SSL socket", 91);
        }
    }

    public InputStream getInputStream() {
        try {
            Object object = this.invokeMethod(this.m_socket, "getInputStream", null);
            return (InputStream)object;
        }
        catch (LDAPException lDAPException) {
            this.printDebug(lDAPException.toString());
            return null;
        }
    }

    public OutputStream getOutputStream() {
        try {
            Object object = this.invokeMethod(this.m_socket, "getOutputStream", null);
            return (OutputStream)object;
        }
        catch (LDAPException lDAPException) {
            this.printDebug(lDAPException.toString());
            return null;
        }
    }

    public void close() throws IOException {
        try {
            this.invokeMethod(this.m_socket, "close", null);
            return;
        }
        catch (LDAPException lDAPException) {
            this.printDebug(lDAPException.toString());
            return;
        }
    }

    public void close(boolean bl) throws IOException {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl)};
            this.invokeMethod(this.m_socket, "close", objectArray);
            return;
        }
        catch (LDAPException lDAPException) {
            this.printDebug(lDAPException.toString());
            return;
        }
    }

    public InetAddress getInetAddress() {
        try {
            Object object = this.invokeMethod(this.m_socket, "getInetAddress", null);
            return (InetAddress)object;
        }
        catch (LDAPException lDAPException) {
            this.printDebug(lDAPException.toString());
            return null;
        }
    }

    public int getLocalPort() {
        try {
            Object object = this.invokeMethod(this.m_socket, "getLocalPort", null);
            return (Integer)object;
        }
        catch (LDAPException lDAPException) {
            this.printDebug(lDAPException.toString());
            return -1;
        }
    }

    public int getPort() {
        try {
            Object object = this.invokeMethod(this.m_socket, "getPort", null);
            return (Integer)object;
        }
        catch (LDAPException lDAPException) {
            this.printDebug(lDAPException.toString());
            return -1;
        }
    }

    private Object invokeMethod(Object object, String string, Object[] objectArray) throws LDAPException {
        try {
            Method method = this.getMethod(string);
            if (method != null) {
                return method.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            throw new LDAPException("Invoking " + string + ": " + exception.toString(), 89);
        }
        return null;
    }

    private Method getMethod(String string) throws LDAPException {
        try {
            Method method = null;
            method = (Method)this.m_methodLookup.get(string);
            if (method != null) {
                return method;
            }
            Class<?> clazz = Class.forName("crysec.SSL.SSLSocket");
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (methodArray[n].getName().equals(string)) {
                    this.m_methodLookup.put(string, methodArray[n]);
                    return methodArray[n];
                }
                ++n;
            }
            throw new LDAPException("Method " + string + " not found in " + "crysec.SSL.SSLSocket");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LDAPException("Class crysec.SSL.SSLSocket not found");
        }
    }

    private void printDebug(String string) {
        System.out.println(string);
    }
}

