/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.EmptyBorder;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Slider
extends View
implements Target,
FormElement {
    Target target;
    Border border = BezelBorder.loweredBezel();
    Image backgroundImage;
    Image knobImage;
    Color backgroundColor = Color.gray;
    String command;
    int value;
    int minValue = 0;
    int maxValue = 255;
    int sliderX;
    int knobHeight = 13;
    int grooveHeight = 8;
    int clickOffset;
    int imageDisplayStyle;
    boolean enabled = true;
    int incrementResolution;
    static Vector _fieldDescription;
    private static final int SLIDER_KNOB_WIDTH = 6;
    static final String TARGET_KEY = "target";
    static final String BACKGROUND_IMAGE_KEY = "backgroundImage";
    static final String KNOB_IMAGE_KEY = "knobImage";
    static final String BACKGROUNDC_KEY = "backgroundColor";
    static final String COMMAND_KEY = "command";
    static final String VALUE_KEY = "value";
    static final String MINVALUE_KEY = "minValue";
    static final String MAXVALUE_KEY = "maxValue";
    static final String KNOB_HEIGHT_KEY = "knobHeight";
    static final String GROOVE_HEIGHT_KEY = "grooveHeight";
    static final String BORDER_KEY = "border";
    static final String ENABLED_KEY = "enabled";
    static final String IMAGEDISP_KEY = "imageDisplayStyle";
    static final String INC_RES_KEY = "incrementResolution";
    public static final String INCREASE_VALUE = "increaseValue";
    public static final String DECREASE_VALUE = "decreaseValue";

    public Slider() {
        this(0, 0, 0, 0);
    }

    public Slider(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public Slider(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.setValue(0);
        this._setupKeyboard();
        this.incrementResolution = 20;
    }

    private static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public Size minSize() {
        if (this._minSize != null) {
            return new Size(this._minSize);
        }
        return new Size(this.knobWidth() + 2, this.knobHeight > this.grooveHeight ? this.knobHeight : this.grooveHeight);
    }

    public void setLimits(int n, int n2) {
        if (n >= n2) {
            return;
        }
        this.minValue = n;
        this.maxValue = n2;
        if (this.value < n) {
            this.value = n;
        } else if (this.value > n2) {
            this.value = n2;
        }
        int n3 = this.value;
        this.value = this.value > 0 ? --this.value : ++this.value;
        this.setValue(n3);
    }

    public int minValue() {
        return this.minValue;
    }

    public int maxValue() {
        return this.maxValue;
    }

    public void setKnobImage(Image image) {
        if (image == this.knobImage) {
            return;
        }
        this.knobImage = image;
        if (image != null) {
            this.knobHeight = image.height();
        }
        this.setValue(this.value);
    }

    public Image knobImage() {
        return this.knobImage;
    }

    public void setBackgroundColor(Color color) {
        if (this.backgroundColor != null) {
            this.backgroundColor = color;
        }
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void setImage(Image image) {
        this.backgroundImage = image;
    }

    public Image image() {
        return this.backgroundImage;
    }

    public void setImageDisplayStyle(int n) {
        if (n != 0 && n != 2 && n != 1) {
            throw new InconsistencyException("Unknown image display style: " + n);
        }
        this.imageDisplayStyle = n;
        this.draw();
    }

    public int imageDisplayStyle() {
        return this.imageDisplayStyle;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Target target() {
        return this.target;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String command() {
        return this.command;
    }

    public void sendCommand() {
        if (this.target != null) {
            this.target.performCommand(this.command, this);
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.draw();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int knobWidth() {
        if (this.knobImage != null) {
            return this.knobImage.width();
        }
        return 6;
    }

    public void setKnobHeight(int n) {
        if (n > 0) {
            this.knobHeight = n;
        }
    }

    public int knobHeight() {
        return this.knobHeight;
    }

    public void setGrooveHeight(int n) {
        if (n > 0) {
            this.grooveHeight = n;
        }
    }

    public int grooveHeight() {
        return this.grooveHeight;
    }

    public void setBorder(Border border) {
        if (border == null) {
            border = EmptyBorder.emptyBorder();
        }
        this.border = border;
        this.setValue(this.value);
    }

    public Border border() {
        return this.border;
    }

    void redrawView(int n) {
        if (this.sliderX == n) {
            return;
        }
        Rect rect = this.sliderX < n ? Rect.newRect(this.sliderX, 0, n - this.sliderX + this.knobWidth(), this.bounds.height) : Rect.newRect(n, 0, this.sliderX - n + this.knobWidth(), this.bounds.height);
        this.draw(rect);
        Rect.returnRect(rect);
    }

    void recomputeSliderPosition() {
        int n = this.value - this.minValue;
        float f = this.maxValue - this.minValue;
        this.sliderX = (int)((float)n / f * (float)(this.bounds.width - this.knobWidth()));
    }

    public void setValue(int n) {
        if (n < this.minValue || n > this.maxValue) {
            return;
        }
        if (this.value != n) {
            this.value = n;
            int n2 = this.sliderX;
            this.recomputeSliderPosition();
            this.redrawView(n2);
        }
    }

    public int value() {
        return this.value;
    }

    public void drawViewGroove(Graphics graphics) {
        int n = (this.bounds.height - this.grooveHeight) / 2;
        Rect rect = Rect.newRect(0, n, this.bounds.width, this.grooveHeight);
        this.border.drawInRect(graphics, rect);
        this.border.computeInteriorRect(rect, rect);
        if (this.backgroundImage != null) {
            graphics.pushState();
            graphics.setClipRect(rect);
            this.backgroundImage.drawWithStyle(graphics, rect, this.imageDisplayStyle);
            graphics.popState();
        } else {
            if (!this.enabled) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(this.backgroundColor);
            }
            graphics.fillRect(rect);
        }
        Rect.returnRect(rect);
    }

    public Rect knobRect() {
        int n = this.knobImage != null ? (this.bounds.height - this.knobImage.height()) / 2 : (this.bounds.height - this.grooveHeight) / 2 - (this.knobHeight - this.grooveHeight) / 2;
        return Rect.newRect(this.sliderX, n, this.knobWidth(), this.knobHeight);
    }

    public void drawViewKnob(Graphics graphics) {
        Rect rect = this.knobRect();
        if (this.knobImage != null) {
            this.knobImage.drawAt(graphics, rect.x, rect.y);
        } else {
            BezelBorder.raisedButtonBezel().drawInRect(graphics, rect);
            graphics.setColor(Color.lightGray);
            graphics.fillRect(rect.x + 2, rect.y + 2, rect.width - 4, rect.height - 4);
        }
        Rect.returnRect(rect);
    }

    public void drawView(Graphics graphics) {
        this.drawViewGroove(graphics);
        this.drawViewKnob(graphics);
    }

    int _positionFromPoint(int n) {
        int n2 = this.knobWidth();
        if ((n -= n2 / 2) < 0) {
            n = 0;
        } else if (n > this.bounds.width - n2) {
            n = this.bounds.width - n2;
        }
        return n;
    }

    void _moveSliderTo(int n) {
        int n2 = this.sliderX;
        this.sliderX = this._positionFromPoint(n);
        this.value = (int)((double)(this.maxValue - this.minValue) / (double)(this.bounds.width - this.knobWidth()) * (double)this.sliderX) + this.minValue;
        this.redrawView(n2);
    }

    public void didSizeBy(int n, int n2) {
        this.recomputeSliderPosition();
        super.didSizeBy(n, n2);
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        if (!this.enabled) {
            return false;
        }
        Rect rect = this.knobRect();
        if (rect.contains(mouseEvent.x, mouseEvent.y)) {
            this.clickOffset = this._positionFromPoint(mouseEvent.x) - this.sliderX;
        } else {
            this.clickOffset = 0;
            this._moveSliderTo(mouseEvent.x);
        }
        this.sendCommand();
        return true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this._moveSliderTo(mouseEvent.x - this.clickOffset);
        this.sendCommand();
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.Slider", 2);
        classInfo.addField(TARGET_KEY, (byte)18);
        classInfo.addField(BACKGROUND_IMAGE_KEY, (byte)18);
        classInfo.addField(KNOB_IMAGE_KEY, (byte)18);
        classInfo.addField(BACKGROUNDC_KEY, (byte)18);
        classInfo.addField(BORDER_KEY, (byte)18);
        classInfo.addField(COMMAND_KEY, (byte)16);
        classInfo.addField(VALUE_KEY, (byte)8);
        classInfo.addField(MINVALUE_KEY, (byte)8);
        classInfo.addField(MAXVALUE_KEY, (byte)8);
        classInfo.addField(KNOB_HEIGHT_KEY, (byte)8);
        classInfo.addField(GROOVE_HEIGHT_KEY, (byte)8);
        classInfo.addField(IMAGEDISP_KEY, (byte)8);
        classInfo.addField(ENABLED_KEY, (byte)0);
        classInfo.addField(INC_RES_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(TARGET_KEY, (Codable)this.target);
        encoder.encodeObject(BACKGROUND_IMAGE_KEY, this.backgroundImage);
        encoder.encodeObject(KNOB_IMAGE_KEY, this.knobImage);
        encoder.encodeObject(BACKGROUNDC_KEY, this.backgroundColor);
        encoder.encodeString(COMMAND_KEY, this.command);
        encoder.encodeInt(VALUE_KEY, this.value);
        encoder.encodeInt(MINVALUE_KEY, this.minValue);
        encoder.encodeInt(MAXVALUE_KEY, this.maxValue);
        encoder.encodeInt(KNOB_HEIGHT_KEY, this.knobHeight);
        encoder.encodeInt(GROOVE_HEIGHT_KEY, this.grooveHeight);
        if (this.border instanceof EmptyBorder) {
            encoder.encodeObject(BORDER_KEY, null);
        } else {
            encoder.encodeObject(BORDER_KEY, this.border);
        }
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        encoder.encodeInt(IMAGEDISP_KEY, this.imageDisplayStyle);
        encoder.encodeInt(INC_RES_KEY, this.incrementResolution);
    }

    public void decode(Decoder decoder) throws CodingException {
        int n = decoder.versionForClassName("netscape.application.Slider");
        super.decode(decoder);
        this.target = (Target)decoder.decodeObject(TARGET_KEY);
        this.backgroundImage = (Image)decoder.decodeObject(BACKGROUND_IMAGE_KEY);
        this.knobImage = (Image)decoder.decodeObject(KNOB_IMAGE_KEY);
        this.backgroundColor = (Color)decoder.decodeObject(BACKGROUNDC_KEY);
        this.command = decoder.decodeString(COMMAND_KEY);
        this.value = decoder.decodeInt(VALUE_KEY);
        this.minValue = decoder.decodeInt(MINVALUE_KEY);
        this.maxValue = decoder.decodeInt(MAXVALUE_KEY);
        this.knobHeight = decoder.decodeInt(KNOB_HEIGHT_KEY);
        this.grooveHeight = decoder.decodeInt(GROOVE_HEIGHT_KEY);
        this.setBorder((Border)decoder.decodeObject(BORDER_KEY));
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        this.imageDisplayStyle = decoder.decodeInt(IMAGEDISP_KEY);
        if (n > 1) {
            this.incrementResolution = decoder.decodeInt(INC_RES_KEY);
            return;
        }
        this.incrementResolution = 20;
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        this.setCommandForKey(INCREASE_VALUE, 1007, 0);
        this.setCommandForKey(DECREASE_VALUE, 1006, 0);
        this.setCommandForKey(INCREASE_VALUE, 43, 0);
        this.setCommandForKey(DECREASE_VALUE, 45, 0);
    }

    public boolean canBecomeSelectedView() {
        return true;
    }

    public void performCommand(String string, Object object) {
        if (INCREASE_VALUE.equals(string)) {
            int n = this.value() + (int)Math.rint((double)(this.maxValue - this.minValue) / (double)this.incrementResolution);
            if (n > this.maxValue) {
                n = this.maxValue;
            }
            this.setValue(n);
            this.sendCommand();
            return;
        }
        if (DECREASE_VALUE.equals(string)) {
            int n = this.value() - (int)Math.rint((double)(this.maxValue - this.minValue) / (double)this.incrementResolution);
            if (n < this.minValue) {
                n = this.minValue;
            }
            this.setValue(n);
            this.sendCommand();
        }
    }

    public int incrementResolution() {
        return this.incrementResolution;
    }

    public void setIncrementResolution(int n) {
        this.incrementResolution = n;
    }

    public String formElementText() {
        return Integer.toString(this.value());
    }
}

