/*
 * Decompiled with CFR 0.152.
 */
package netscape.softupdate;

import java.text.MessageFormat;
import netscape.security.AppletSecurity;
import netscape.security.PrivilegeManager;
import netscape.security.Target;
import netscape.softupdate.FolderSpec;
import netscape.softupdate.InstallObject;
import netscape.softupdate.SoftUpdateException;
import netscape.softupdate.SoftwareUpdate;
import netscape.softupdate.Strings;
import netscape.softupdate.VersionInfo;
import netscape.softupdate.VersionRegistry;

final class InstallPatch
extends InstallObject {
    private String vrName;
    private VersionInfo versionInfo;
    private String jarLocation;
    private String patchURL;
    private String targetfile;
    private String patchedfile;

    InstallPatch(SoftwareUpdate softwareUpdate, String string, VersionInfo versionInfo, String string2) throws SoftUpdateException {
        super(softwareUpdate);
        this.vrName = string;
        this.versionInfo = versionInfo;
        this.jarLocation = string2;
        this.targetfile = VersionRegistry.componentPath(this.vrName);
        if (this.targetfile == null) {
            throw new SoftUpdateException("", -213);
        }
        this.checkPrivileges();
    }

    InstallPatch(SoftwareUpdate softwareUpdate, String string, VersionInfo versionInfo, String string2, FolderSpec folderSpec, String string3) throws SoftUpdateException {
        super(softwareUpdate);
        this.vrName = string;
        this.versionInfo = versionInfo;
        this.jarLocation = string2;
        this.targetfile = folderSpec.MakeFullPath(string3);
        this.checkPrivileges();
    }

    private void checkPrivileges() {
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget("Impersonator");
        Target target2 = Target.findTarget("SoftwareInstall");
        privilegeManager.enablePrivilege(target);
        privilegeManager.enablePrivilege(target2, this.softUpdate.GetPrincipal());
    }

    protected void Prepare() throws SoftUpdateException {
        int n = 0;
        String string = null;
        boolean bl = false;
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget("Impersonator");
        Target target2 = Target.findTarget("SoftwareInstall");
        privilegeManager.enablePrivilege(target);
        privilegeManager.enablePrivilege(target2, this.softUpdate.GetPrincipal());
        try {
            this.NativeDoesFileExist(this.targetfile);
        }
        catch (SoftUpdateException softUpdateException) {
            n = softUpdateException.GetError();
        }
        if (n == 0) {
            this.patchURL = this.softUpdate.ExtractJARFile(this.jarLocation, this.targetfile);
            if (this.softUpdate.patchList.containsKey(this.targetfile)) {
                string = (String)this.softUpdate.patchList.get(this.targetfile);
                bl = true;
            } else {
                string = this.targetfile;
                bl = false;
            }
            try {
                this.patchedfile = this.NativePatch(string, this.patchURL);
            }
            catch (SoftUpdateException softUpdateException) {
                n = softUpdateException.GetError();
            }
            if (this.patchedfile != null) {
                this.softUpdate.patchList.put(this.targetfile, this.patchedfile);
            }
        }
        if (bl) {
            this.NativeDeleteFile(string);
        }
        if (n != 0) {
            Object[] objectArray = new Object[]{this.targetfile};
            throw new SoftUpdateException(MessageFormat.format(Strings.error_PatchFailed(), objectArray), n);
        }
    }

    protected void Complete() throws SoftUpdateException {
        this.checkPrivileges();
        String string = (String)this.softUpdate.patchList.get(this.targetfile);
        if (string.compareTo(this.patchedfile) == 0) {
            int n = this.NativeReplace(this.targetfile, this.patchedfile);
            if (n == 0 || n == 999) {
                VersionRegistry.installComponent(this.vrName, this.targetfile, this.versionInfo);
                if (n != 0) {
                    throw new SoftUpdateException(this.targetfile, n);
                }
            } else {
                Object[] objectArray = new Object[]{this.targetfile};
                throw new SoftUpdateException(MessageFormat.format(Strings.error_InstallFileUnexpected(), objectArray), n);
            }
        }
    }

    protected void Abort() {
        String string = (String)this.softUpdate.patchList.get(this.targetfile);
        if (string.compareTo(this.patchedfile) == 0) {
            this.NativeDeleteFile(this.patchedfile);
        }
    }

    private native String NativePatch(String var1, String var2) throws SoftUpdateException;

    private native int NativeReplace(String var1, String var2);

    private native void NativeDeleteFile(String var1);

    public String toString() {
        Object[] objectArray = new Object[]{this.targetfile};
        return MessageFormat.format(Strings.details_Patch(), objectArray);
    }

    protected boolean CanUninstall() {
        return true;
    }

    protected boolean RegisterPackageNode() {
        return true;
    }
}

