/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.client.JDAPMessage;

class LDAPSearchListener
extends LDAPResponseListener {
    private Vector searchResults;
    private Long m_key;
    private LDAPSearchConstraints m_constraints;

    LDAPSearchListener(LDAPConnection lDAPConnection, LDAPSearchConstraints lDAPSearchConstraints) {
        super(lDAPConnection);
        this.m_constraints = lDAPSearchConstraints;
        this.searchResults = new Vector();
    }

    synchronized void addSearchResult(JDAPMessage jDAPMessage) {
        this.searchResults.addElement(jDAPMessage);
        this.notifyAll();
    }

    Enumeration getSearchResults() {
        return this.searchResults.elements();
    }

    int getCount() {
        return this.searchResults.size();
    }

    void reset() {
        super.reset();
        if (this.searchResults != null) {
            this.searchResults.removeAllElements();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    JDAPMessage nextResult() {
        JDAPMessage jDAPMessage;
        LDAPSearchListener lDAPSearchListener = this;
        synchronized (lDAPSearchListener) {
            while (true) {
                if (this.searchResults.size() >= 1) {
                    jDAPMessage = (JDAPMessage)this.searchResults.elementAt(0);
                    this.searchResults.removeElementAt(0);
                    break;
                }
                if (this.isResponseReceived()) {
                    this.searchResults.removeAllElements();
                    return null;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.getConnection().resultRetrieved();
        return jDAPMessage;
    }

    LDAPSearchConstraints getConstraints() {
        return this.m_constraints;
    }

    void setKey(Long l) {
        this.m_key = l;
    }

    Long getKey() {
        return this.m_key;
    }
}

