/*
** 1998-08-23 -	Header file for the helper module "list_dialog". Very simple.
*/

#if !defined(LIST_DIALOG_H)
#define	LIST_DIALOG_H

/* This is called when the user clicked OK in the dialog, thus selecting a
** row from the list display. The pointer <data> will be the list data for
** the selected row, and <user_data> will contain the pointer provided in
** the ldl_dialog() call.
*/
typedef void (*LDlgFunction)(gpointer data, gpointer user_data);

/* This function is used to convert a list <data> pointer to a string,
** i.e. something more suitable to add to a list. The string returned is
** immediately used in a call to gtk_clist_append(), so it can be over-
** written the next time. If NULL is returned, the line will not be shown.
**   If NULL is specified as the filter, the data itself will be used;
** this is handy for lists of plain strings.
*/
typedef char * (*LDlgFilter)(gpointer data, gpointer user_data);

void	ldl_dialog(GList *list, LDlgFilter filter, LDlgFunction func, gpointer user_data);

#endif		/* LIST_DIALOG_H */
