/*
** 1998-08-23 -	Another helper module. This one uses the good old dialog module to
**		present the user with the choice of selecting something from a GList
**		of stuff. Initially created for the "reparent" button in style-config.
** 1999-03-13 -	Adapted for the new dialog module.
*/

#include "gentoo.h"
#include "dialog.h"
#include "list_dialog.h"

/* ----------------------------------------------------------------------------------------- */

typedef struct {
	Dialog		*dlg;
	gint		open : 1;
	GtkWidget	*scwin;
	GtkWidget	*clist;
	gpointer	user;
	LDlgFunction	func;
	gpointer	*curr_data;
} LDlgInfo;

/* ----------------------------------------------------------------------------------------- */

/* 1998-08-23 -	The callback that the dialog module calls. Time for more callbacking. */
static void done(Dialog *dlg, guint response, void *data)
{
	LDlgInfo	*ldl = (LDlgInfo *) data;

	if((response == DLG_POSITIVE) && (ldl->func != NULL))
		ldl->func(ldl->curr_data, ldl->user);
}

/* ----------------------------------------------------------------------------------------- */

/* 1998-08-23 -	User just selected a new row in the clist. Record corresponding data. */
static gint evt_clist_select(GtkWidget *wid, gint row, gint column, GdkEventButton *evt)
{
	LDlgInfo	*ldl = (LDlgInfo *) gtk_object_get_user_data(GTK_OBJECT(wid));

	if(!ldl->open)
		return TRUE;

	ldl->curr_data = gtk_clist_get_row_data(GTK_CLIST(ldl->clist), row);
	if(evt != NULL && evt->button == 1 && evt->type == GDK_2BUTTON_PRESS)
		dlg_dialog_close_left(ldl->dlg);

	return TRUE;
}

/* ----------------------------------------------------------------------------------------- */

/* 1998-08-23 -	A list dialog. Very useful. */
void ldl_dialog(GList *list, LDlgFilter filter, LDlgFunction func, gpointer user_data)
{
	static LDlgInfo	ldl;
	GList		*item;
	char		*row;
	gint		index;

	ldl.open = 0;
	ldl.user = user_data;
	ldl.func = func;
	ldl.curr_data = NULL;

	ldl.scwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ldl.scwin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(ldl.scwin, 200, 300);

	ldl.clist = gtk_clist_new(1);
	gtk_clist_set_selection_mode(GTK_CLIST(ldl.clist), GTK_SELECTION_BROWSE);
	gtk_object_set_user_data(GTK_OBJECT(ldl.clist), (gpointer) &ldl);
	gtk_signal_connect(GTK_OBJECT(ldl.clist), "select_row", GTK_SIGNAL_FUNC(evt_clist_select), (gpointer) &ldl);
	for(item = list; item != NULL; item = g_list_next(item))
	{
		if(item->data != NULL)
		{
			row = filter == NULL ? (char *) item->data : filter(item->data, user_data);
			if(row != NULL)
			{
				index = gtk_clist_append(GTK_CLIST(ldl.clist), &row);
				gtk_clist_set_row_data(GTK_CLIST(ldl.clist), index, item->data);
			}
		}
	}
	ldl.open = 1;
	gtk_clist_select_row(GTK_CLIST(ldl.clist), 0, -1);	/* Selects root type. */
	gtk_container_add(GTK_CONTAINER(ldl.scwin), ldl.clist);
	gtk_widget_show(ldl.clist);
	ldl.dlg = dlg_dialog(ldl.scwin, NULL, "OK|Cancel", done, &ldl);
}
