/*
** 1998-08-08 -	The Swap command is reborn, sort of. This swaps the contents of the panes,
**		not the active one. Very useful.
** 1998-08-27 -	Since this module was so small, I crammed in another command; the Other
**		command, which simply "copies" the directory from the other dirpane into
**		the one current. Very useful, believe it or not.
** 1999-03-06 -	Adapted for the new selection handling.
*/

#include "gentoo.h"
#include "dirpane.h"
#include "strutil.h"
#include "dirhistory.h"

#include "cmd_swap.h"

/* ----------------------------------------------------------------------------------------- */

/* 1999-04-25 -	Updated to play by the new selection rules, and also understand that the
**		path is displayed in a combo, and not a plain GtkEntry. Far less efficient
**		now, though. Too bad.
*/
int cmd_swap(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	DirContents	tmp;

	tmp = src->dir;
	src->dir = dst->dir;
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(src->path)->entry), src->dir.path);
	dst->dir = tmp;
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(dst->path)->entry), dst->dir.path);
	dp_redisplay_preserve(src);
	dp_redisplay_preserve(dst);

	return 1;
}

/* ----------------------------------------------------------------------------------------- */

/* 1998-09-20 -	Assume that <dst> and <src> show the same path; copy the selection from <src>
**		into <dst>.
** 1999-03-06 -	Rewritten using the new selection abstraction and stuff. Probably takes 100
**		times longer to run now... Not a big deal.
*/
static void get_selection(DirPane *dst, DirPane *src)
{
	DHSel	*sel;

	if((sel = dph_dirsel_create(src)) != NULL)
	{
		dph_dirsel_apply(dst, sel);
		dph_dirsel_destroy(sel);
	}
}

/* 1998-08-27 -	Go to the same directory as the other (i.e. destination) pane. */
int cmd_fromother(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	dp_freeze(src);
	dp_unselect_all(src);
	dp_enter_dir(src, dst->dir.path);
	get_selection(src, dst);
	dp_thaw(src);

	return 1;
}

/* 1998-09-20 -	Added this to complement the old DirOther command, which was also renamed. */
int cmd_toother(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	dp_freeze(dst);
	dp_unselect_all(dst);
	dp_enter_dir(dst, src->dir.path);
	get_selection(dst, src);
	dp_thaw(dst);

	return 1;
}
