/*
** 1998-09-23 -	No program is complete without an "About" command.
** 1999-03-13 -	Now uses a multi dialog, which allows setting a sensible title. :)
** 1999-03-21 -	Brought the copyright into 1999, and added fun page flipping. :)
*/

#include "gentoo.h"
#include "dialog.h"

#include "cmd_about.h"

#define	CMD_ID	"about"

/* ----------------------------------------------------------------------------------------- */

#include "graphics/icon_gentoo.xpm"

/* ----------------------------------------------------------------------------------------- */

struct body {
	GtkWidget	*page[2];
};

/* ----------------------------------------------------------------------------------------- */

static gint timeout(gpointer data)
{
	static gint	page = 0;

	gtk_widget_hide(((struct body *) data)->page[page]);
	page ^= 1;
	gtk_widget_show(((struct body *) data)->page[page]);

	return TRUE;
}

int cmd_about(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	static char	buf[64];
	guint		handler;
	GtkWidget	*hbox, *w;
	GdkPixmap	*pmap;
	GdkBitmap	*mask;
	Dialog		*dlg;
	struct body	body;

	g_snprintf(buf, sizeof buf, "Version %s (GTK+ version %d.%d.%d).", VERSION,
			gtk_major_version, gtk_minor_version, gtk_micro_version);

	hbox = gtk_hbox_new(FALSE, 0);
	body.page[0] = gtk_vbox_new(FALSE, 0);
	if((pmap = gdk_pixmap_create_from_xpm_d(GTK_WIDGET(min->gui->window)->window, &mask, NULL, icon_gentoo_xpm)) != NULL)
	{
		w = gtk_pixmap_new(pmap, mask);
		gtk_box_pack_start(GTK_BOX(body.page[0]), w, FALSE, FALSE, 5);
		gtk_widget_show(w);
		w = gtk_label_new(buf);
		gtk_box_pack_start(GTK_BOX(body.page[0]), w, FALSE, FALSE, 0);
		gtk_widget_show(w);
		w = gtk_label_new("(c) 1998-99 by Emil Brink, Obsession Development.\n"
				"This is free software, and there is ABSOLUTELY NO\n"
				"WARRANTY. Read the file COPYING for more details.");
		gtk_box_pack_start(GTK_BOX(body.page[0]), w, FALSE, FALSE, 0);
		gtk_widget_show(w);
	}
	gtk_box_pack_start(GTK_BOX(hbox), body.page[0], TRUE, TRUE, 0);
	gtk_widget_show(body.page[0]);
	body.page[1] = gtk_label_new(	"The author of gentoo can be reached via Internet\n"
					"e-mail at <emil@obsession.se>; feel free to let\n"
					"me know what you think of this software, give\n"
					"suggestions/bug reports, and so on.\n\n"

					"The latest release of gentoo can always be down-\n"
					"loaded from the official gentoo project homepage at\n"
					"<http://www.obsession.se/gentoo>. New releases are\n"
					"typically announced on the Freshmeat service at\n"
					"<http://freshmeat.net>.");
	gtk_box_pack_start(GTK_BOX(hbox), body.page[1], TRUE, TRUE, 0);
	handler = gtk_timeout_add(10000, timeout, &body);
	dlg = dlg_dialog(hbox, "About gentoo", "OK", NULL, NULL);
	dlg_dialog_wait(dlg);
	gtk_timeout_remove(handler);
	return 1;
}
