/*
** 1999-05-02 -	A little color dialog module. Really just a convenience wrapper around
**		the GTK+ GtkColorSelection widget. Saves a few uppercase keystrokes.
*/

#include "gentoo.h"

#include "dialog.h"
#include "color_dialog.h"

typedef struct {
	GtkWidget	*colsel;		/* The core widget. */
	ColChangedFunc	func;
	gpointer	user;
} ColDlg;

/* ----------------------------------------------------------------------------------------- */

/* 1999-05-02 -	This gets called as the user changes color controls in dialog. Call callback. */
static void evt_color_changed(GtkWidget *wid, gpointer user)
{
	ColDlg		*dlg = user;

	if(dlg->func != NULL)
	{
		gdouble		rgb[3];
		GdkColor	col;

		gtk_color_selection_get_color(GTK_COLOR_SELECTION(dlg->colsel), rgb);
		col.pixel = 0UL;
		col.red   = rgb[0] * 65535.0;
		col.green = rgb[1] * 65535.0;
		col.blue  = rgb[2] * 65535.0;
		dlg->func(&col, dlg->user);
	}
}

guint cdl_dialog(const gchar *label, ColChangedFunc func, GdkColor *initial, gpointer user)
{
	static ColDlg	dlg;
	Dialog		*d;

	dlg.func = func;
	dlg.user = user;

	dlg.colsel = gtk_color_selection_new();
	gtk_color_selection_set_update_policy(GTK_COLOR_SELECTION(dlg.colsel), GTK_UPDATE_CONTINUOUS);
	gtk_signal_connect(GTK_OBJECT(dlg.colsel), "color_changed", GTK_SIGNAL_FUNC(evt_color_changed), &dlg);
	if(initial != NULL)
	{
		gdouble	color[3];

		color[0] = initial->red   / 65535.0;
		color[1] = initial->green / 65535.0;
		color[2] = initial->blue  / 65535.0;
		gtk_color_selection_set_color(GTK_COLOR_SELECTION(dlg.colsel), color);
	}

	if((d = dlg_dialog(dlg.colsel, label ? label : "Edit Color", "OK|Cancel", NULL, NULL)) != NULL)
	{
		guint	response;

		response = dlg_dialog_wait(d);
		return response;
	}
	return 1;
}
