/*
** 1998-05-25 -	The PARENT native command, which simply causes the currently active
**		dir pane to go up one level, to its parent directory.
*/

#include "gentoo.h"

#include <stdlib.h>

#include "dirpane.h"
#include "dirhistory.h"

#include "cmd_parent.h"

/* ----------------------------------------------------------------------------------------- */

/* 1998-05-25 -	Go up one level. The <src> destination is the one operated upon, the <dst> is
**		simply ignored.
** 1998-05-25 -	Rewritten. Removed a useless strlen(), and stopped modifying dp->dir.path[]
**		from here. Now builds new path in dynamically allocated memory and calls
**		dp_enter_dir() like everybody else.
*/
int cmd_parent(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	gchar	*tmp, *lsl;
	gint	new_len;

	if((tmp = g_strdup(src->dir.path)) != NULL)
	{
		if((lsl = strrchr(tmp, '/')) != NULL)
		{
			while(*(lsl - 1) == '/')
				lsl--;
			new_len = lsl - tmp + 1;
			if(new_len > 0)
			{
				tmp[new_len] = '\0';
				dp_enter_dir(src, tmp);
			}
		}
		g_free(tmp);
	}
	return errno == 0;
}

/* ----------------------------------------------------------------------------------------- */

/* 1998-12-16 -	Make the source pane enter the previous directory it was in.
** BUG BUG BUG	Since the history is reordered when written to, this doesn't really work well. :(
*/
int cmd_dirprevious(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	char	*path;

	if((path = dph_previous(src)) != NULL)
		dp_enter_dir(src, path);
	return TRUE;
}
