/*
** 1998-09-12 -	This module contains code to allow the user to select a style from a
**		simple list representation. This is used in two places; the "reparent"
**		button in cfg_styles, and the "style" button in cfg_types. Since the
**		old (short, inline) approach was severely broken, this needs a module
**		of its own.
** 1999-05-24 -	More or less completely rewritten. About 1/4 the size of the old one.
*/

#include "gentoo.h"

#include <stdlib.h>

#include "styles.h"
#include "dialog.h"
#include "style_dialog.h"

/* ----------------------------------------------------------------------------------------- */

/* 1999-05-27 -	Selection changed in style tree. */
static void evt_selection_changed(GtkWidget *wid, gpointer user)
{
	GList	*slist;
	Style	**sel = user;

	if((slist = GTK_TREE_SELECTION(GTK_TREE(wid))) != NULL)
		*sel = stl_style_get(slist->data);
}

/* 1999-05-24 -	Main style dialog entry point. */
Style * sdl_dialog(StyleInfo *si, Style *ignore)
{
	GtkWidget	*scwin, *tree;
	Style		*sel = NULL;
	Dialog		*dlg;

	scwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scwin), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	tree = GTK_WIDGET(stl_styleinfo_build_partial(si, ignore));
	gtk_signal_connect(GTK_OBJECT(tree), "selection_changed", GTK_SIGNAL_FUNC(evt_selection_changed), &sel);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scwin), tree);
	gtk_widget_show(tree);
	gtk_widget_show(scwin);
	gtk_widget_set_usize(scwin, 200, 300);
	dlg = dlg_dialog(scwin, "Select Style", "OK|Cancel", NULL, NULL);
	if(dlg_dialog_wait(dlg) == 0)
		return sel;
	return NULL;
}
