/*
** 1998-12-19 -	Toggle the hide allowed flag of the source pane, update the toggle button
**		accordingly, and do a rescan.
** 1999-03-15 -	Stuck the DpRecenter command in here, and renamed the entire module (was dphide).
*/

#include "gentoo.h"

#include "cmdseq.h"
#include "cmd_dpmisc.h"

/* ----------------------------------------------------------------------------------------- */

int cmd_dphide(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	DPFormat	*fmt;

	fmt = &min->cfg.dp_format[src->index];
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(src->hide), !fmt->hide_allowed);
	csq_execute(min, "DirRescan");

	return 1;
}

/* 1999-03-15 -	Recenter the horizontal pane betweeen the, er, panes. Very useful. */
int cmd_dprecenter(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	gint	ww;

	gdk_window_get_size(min->gui->window->window, &ww, NULL);
	gtk_paned_set_position(GTK_PANED(min->gui->hpane), ww / 2);
	return 1;
}
