/*
** 1998-05-25 -	Another basic GUI command, the native SWAP command handles changing of
**		the current dir pane. Very handy for that Opus-like feeling!
** 1998-07-01 -	Expanded, generalized, and renamed this one. The commands implemented
**		here are now called ActivateOther (which does the same thing the old
**		SWAP command did), ActivateLeft, and ActivateRight.
** 1999-01-30 -	Added the stack support, which is sometimes handy to have.
*/

#include "gentoo.h"
#include "dirpane.h"
#include "cmd_activate.h"

/* ----------------------------------------------------------------------------------------- */

#define	DP_STACK_MAX	(8)

typedef struct {
	gint	stack_ptr;		/* Points at next free item in stack. */
	DirPane	*stack[DP_STACK_MAX];	/* Stack of previously active panes. */
} AcStack;

static AcStack	the_stack = { 0 };

/* ----------------------------------------------------------------------------------------- */

/* 1998-05-25 -	Do the swap. Very simple, since the pre-command-execution logic has
**		been kind enough to determine the current (<src>) and not-current
**		(<dst>) panes. Of course, the swap is just a change to <dst>!
** 1998-07-01 -	Renamed.
*/
int cmd_activateother(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	dp_set(dst);
	return 1;
}

/* 1998-07-01 -	Make sure the activate pane is the left one. */
int cmd_activateleft(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	dp_set(&min->gui->pane[0]);
	return 1;
}

/* 1998-07-01 -	Make sure the active pane is the right one. */
int cmd_activateright(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	dp_set(&min->gui->pane[1]);
	return 1;
}

/* 1999-01-30 -	Push currently active pane onto stack. Handy if you want to
**		reactivate it later. Stack is finite and won't wrap; any attempt
**		to push more than it can hold will be (silently) ignored.
*/
int cmd_activatepush(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	if(the_stack.stack_ptr < (sizeof the_stack.stack / sizeof the_stack.stack[0]))
		the_stack.stack[the_stack.stack_ptr++] = src;

	return 1;
}

/* 1999-01-30 -	Activate the entry from the top of the stack. */
int cmd_activatepop(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	if(the_stack.stack_ptr > 0)
		dp_set(the_stack.stack[--the_stack.stack_ptr]);
	return 1;
}
