@ECHO OFF
CLS
IF "%1"=="" GOTO SYNTAX
IF "%2"=="" GOTO SYNTAX

IF NOT "%2"=="\" GOTO JUMP1
ECHO ERROR: Cannot install to root directory.
GOTO ERROR

:JUMP1
IF EXIST INSTALL.DAT GOTO JUMP2
ECHO ERROR: SuperSonic installation files were not found in
ECHO        the current drive/directory. Please change to
ECHO        the drive/directory containing the SuperSonic
ECHO        installation files and try again.
GOTO ERROR

:JUMP2
IF NOT EXIST %1%2\SS.EXE GOTO JUMP3
CLS
ECHO ERROR: SuperSonic already installed at %1%2
GOTO ERROR

:JUMP3
IF NOT EXIST %1%2\NUL GOTO JUMP4
ECHO ERROR: %1%2 directory already being used
ECHO        by another program.
GOTO ERROR

:JUMP4
MD %1%2>NUL
IF EXIST %1%2\NUL GOTO JUMP5
CLS
ECHO ERROR: Could not create directory %1%2
GOTO ERROR

:JUMP5
ECHO Copying archive ...
COPY INSTALL.DAT %1%2\ARCHIVE.EXE>NUL
%1>NUL
CD %2>NUL
ECHO Extracting files ...
ARCHIVE
DEL ARCHIVE.EXE>NUL
CLS
ECHO SuperSonic has been installed to %1%2

:ERROR
ECHO 
ECHO:
ECHO Press Any Key ...
PAUSE>NUL
ECHO:
GOTO QUIT

:SYNTAX
ECHO Ŀ
ECHO  SuperSonic Installation 
ECHO 
ECHO:
ECHO Note:     This should be used only if INSTALL.EXE fails.
ECHO Syntax:   INSTALL.BAT [drive] [dir]
ECHO           drive = destination drive
ECHO           dir   = destination directory
ECHO Example:  INSTALL.BAT C: \SS       
ECHO           Installs SuperSonic to drive C:, directory \SS.
ECHO:
:QUIT
