/****************************************************************************

    Module  : DockWin.c

    Version : v1.0alpha

    Date    : 20/8/93

    Changes :  20/8/93 - Changed code which distinguishes between Windows
               .EXEs & DOS .EXEs to correctly choose.
               20/8/93 - Added use of RePaintSlot func to individually repaint
               slots.

               13/9/93 - Changed code which sets the window position when the
               user starts an application which has it's window position
               stored. Code now finds top parent window of currently active
               window instead of currently active window.

               30/3/94 - corrected code to handle the mail box shrinking &
               getting the correct size after. Tidied up the mail timer when
               the app finished. Corrected a bug which allowed the right
               button click to be processed whilst a slot was being dragged.

*****************************************************************************/

/****************************************************************************

    FUNCTION: DockWinProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)

    VERSION : v1.0

    PURPOSE :

    MESSAGES:

    COMMENTS:

****************************************************************************/


#include <windows.h>            /* include standard windows header */
#include <shellapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys\stat.h>
#include <string.h>
#include "freedock.h"           /* include control message definitions */

/**********************************************************
	Global Data for the various system metrics we need
**********************************************************/
int           gScreenWidth;
int           gScreenHeight;
int           gIconWidth;
int           gIconHeight;
int 		  gDlgTitleHeight;
int 		  gDlgFrameWidth;
int 		  gDlgFrameHeight;

FARPROC  lpfnAboutDockDlgProc;	// Used in dockutil.c


long FAR PASCAL DockWinProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    PAINTSTRUCT     ps;         /* paint struct , used when painting window */
    static HDC      Win_hdc, Screen_hdc;
    static HANDLE   hInst;      /* stores instance handle of application */
    static HCURSOR  hRemCur;
    UINT            SlotHit, FileIndex, nItem, Status;
    int             i, StartSlot, EndSlot;
    HANDLE          hDrop;
    int             SlotIndex, nDropSlot;
	UINT			nNumDropped;
    char            DroppedFileName[MAX_FPATH_LEN], TmpBuffer[MAX_FPATH_LEN];
    char           *TmpCharPtr;
    POINT           DropPoint;
    char            CommandLine[MAX_CMDLINE_LEN];
    static FARPROC  lpfnAppOptionsDlgProc, lpfnMainOptionsDlgProc, lpfnMailOptionsDlgProc, lpfnClockOptionsDlgProc,
                    lpfnWinExitOptionsDlgProc;
    static int      OrigSlot;
    int             NewX, NewY;
    static BOOL     bDragIcon, bRemoveSlot, bSlotOffDock, bSlotMove;
    static HBITMAP  hbmUnderIcon, hbmNewUnderIcon, hbmTmp;
    static HBITMAP  hbmOldUnderIcon, hbmOldNewUnderIcon, hbmOldTmp, hbmOldIconCache;
    static HDC      hdcUnderIcon, hdcNewUnderIcon, hdcTmp;
    struct stat     StatBuf;

    static int      OldLeft, OldTop, OffLeft, OffTop;  // Old coordinates and Offset coordinates
    static RECT     MoveRect, Rect;
    static BOOL     bDragDock;
    static BOOL     bWindowPositioned = FALSE;

    /* Select messages which are handled by this procedure */

    switch (message) {

        case WM_CREATE:             /* The window has just been created */


            /* deretmine the instance handle of the application */
            hInst = ((LPCREATESTRUCT) lParam)->hInstance;

            /*************************************************************
               Determine the size of the screen, used to size and
               position the window.
            *************************************************************/
            gScreenWidth    = GetSystemMetrics(SM_CXSCREEN);
            gScreenHeight   = GetSystemMetrics(SM_CYSCREEN);
            gIconWidth      = GetSystemMetrics(SM_CXICON);
            gIconHeight     = GetSystemMetrics(SM_CYICON);
			gDlgTitleHeight = GetSystemMetrics(SM_CYCAPTION);
			gDlgFrameWidth  = GetSystemMetrics(SM_CXDLGFRAME);
			gDlgFrameHeight = GetSystemMetrics(SM_CYDLGFRAME);

            /********************************************************
                malloc the memory for the maximum number of slots
            ********************************************************/
            Slot = (SLOT_ENTRY *)calloc(DOCK_MAX_SIZE, sizeof(SLOT_ENTRY));
            if(Slot == NULL){
                MessageBox( NULL, "FreeDock Error",
                    "Cannot allocate memory for dock slots",
                    MB_ICONSTOP | MB_OK); 
                exit(-3);
            }

            /*********************************************
                No need to initialise all slot types to
                being free since SLOT_FREE is 0 and we
                used calloc to get the memory
            *********************************************/

           /**********************************************************************
                Create bitmaps and device contexts for the icon cache Item at end
                of cache is for TmpSlot/Icons scratch space
            **********************************************************************/
            Win_hdc = GetDC(hwnd);
            DockOptions.hbmIconCache = CreateCompatibleBitmap( Win_hdc, (gIconWidth * (DOCK_MAX_SIZE+1)), gIconHeight );
            DockOptions.hdcIconCache = CreateCompatibleDC(Win_hdc);
            hbmOldIconCache = SelectObject(DockOptions.hdcIconCache, DockOptions.hbmIconCache);
            ReleaseDC( hwnd, Win_hdc );
			/**********************************************************            
            	Initialise each Slots Icon position within the cache
			**********************************************************/                                                                       
			for( i=0; i < DOCK_MAX_SIZE; i++ ){
			 	Slot[i].IconIndex = i * gIconWidth;
			}                                                                       
			
            /**************************
                Read in all slot info
            **************************/

            ReadINIFile(hwnd, hInst, Slot);

            /****************************************************
                Create a bitmap to store what is under the icon
                when moving a slot, + A scratch pad of the same
                size. (Tmp)
            ****************************************************/
            Win_hdc = GetDC(hwnd);
			hbmUnderIcon = CreateCompatibleBitmap( Win_hdc,
                                                   SLOT_BUTTON_WIDTH,
                                                   SLOT_BUTTON_HEIGHT );
            hbmNewUnderIcon = CreateCompatibleBitmap( Win_hdc,
                                                      SLOT_BUTTON_WIDTH,
                                                      SLOT_BUTTON_HEIGHT );
            hbmTmp = CreateCompatibleBitmap( Win_hdc,
                                             SLOT_BUTTON_WIDTH,
                                             SLOT_BUTTON_HEIGHT );
            hdcUnderIcon    = CreateCompatibleDC(Win_hdc);
            hdcNewUnderIcon = CreateCompatibleDC(Win_hdc);
            hdcTmp          = CreateCompatibleDC(Win_hdc);
            ReleaseDC(hwnd, Win_hdc);

			hbmOldUnderIcon    = SelectObject(hdcUnderIcon,    hbmUnderIcon);
            hbmOldNewUnderIcon = SelectObject(hdcNewUnderIcon, hbmNewUnderIcon);
            hbmOldTmp          = SelectObject(hdcTmp,          hbmTmp);

            /******************************************************
                Identify this window as a drag and drop acceptor
            ******************************************************/
            DragAcceptFiles(hwnd, TRUE);

            bDragIcon = FALSE;
            bDragDock = FALSE;
            /**************************************************
            * Create all proc instances for all dialog boxes *
            **************************************************/
            lpfnAppOptionsDlgProc = MakeProcInstance((FARPROC) AppOptionsDlgProc, hInst);
            lpfnWinExitOptionsDlgProc = MakeProcInstance((FARPROC) WinExitOptionsDlgProc, hInst);
            lpfnMailOptionsDlgProc = MakeProcInstance((FARPROC) MailOptionsDlgProc, hInst);
            lpfnMainOptionsDlgProc = MakeProcInstance((FARPROC) MainOptionsDlgProc, hInst);
            lpfnClockOptionsDlgProc = MakeProcInstance((FARPROC) ClockOptionsDlgProc, hInst);
            lpfnAboutDockDlgProc = MakeProcInstance((FARPROC) AboutDockDlgProc, hInst);

            if (DockOptions.AlwaysOnTop) {
                SetWindowPos(hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
            }
            if (DockOptions.MailActive) {
                SetTimer(hwnd, MAIL_TIMER, DockOptions.MailFreq * 1000 * 60, NULL);
            }
            return 0;               /* end of WM_CREATE */


        case WM_PAINT:
            /** Make sure the dock is in the correct position **/
            /** Cannot do this from WM_CREATE Message         **/
    		if( !bWindowPositioned ){
    		    SetDockWinPos( DockOptions.Position + QX_HORZ );
                bWindowPositioned = TRUE;
            }

			Win_hdc = BeginPaint(hwnd, &ps);
            StartSlot = FindSlotHit(DockOptions.Position, ps.rcPaint.left, ps.rcPaint.top);
            EndSlot = FindSlotHit(DockOptions.Position, ps.rcPaint.right, ps.rcPaint.bottom);

			for (i = StartSlot; i <= EndSlot; i++) {
                PaintSlot(Win_hdc, i);
            }
			EndPaint(hwnd, &ps);
			return 0;


        case WM_TIMER:
            if (wParam == MAIL_TIMER) {
                stat(DockOptions.MailPath, &StatBuf);
                if (StatBuf.st_size > DockOptions.MailBoxSize) {
                    DockOptions.MailBoxSize = (unsigned long) StatBuf.st_size;
                    i = 0;
                    while ((Slot[i].SlotType != SLOT_SPECIAL_MAIL) && (i < 4))
                        i++;
                    if (Slot[i].SlotType != SLOT_SPECIAL_MAIL){
                        KillTimer(hwndDock, MAIL_TIMER);
                        return 0;
                    }
                    DockOptions.bMailInBox = TRUE;
                    UtilLoadIcon( &Slot[i] );
                    if (DockOptions.MailSound) {
                        MessageBeep(MB_ICONHAND);
                    }
                    RePaintSlot(i, FALSE);
                } 
                else if (StatBuf.st_size < DockOptions.MailBoxSize) {
                    DockOptions.MailBoxSize = (unsigned long) StatBuf.st_size;
                }
            }
            return 0;

        case WM_LBUTTONDOWN:
            SetCapture(hwnd);
            OldLeft = LOWORD(lParam);
            OldTop = HIWORD(lParam);
            OrigSlot = FindSlotHit(DockOptions.Position, OldLeft, OldTop);
            if(Slot[OrigSlot].SlotType == SLOT_USED){
                /***********************************************************
                    Delete slot temporaraly & FORCE a repaint before
                    going any further.
                ***********************************************************/
                Slot[OrigSlot].SlotType = SLOT_FREE;
                bDragIcon = TRUE;
                bSlotMove = FALSE;
                bRemoveSlot = FALSE;
                bDragDock = FALSE;
            }
            else if(Slot[OrigSlot].SlotType == SLOT_SPECIAL_TITLE){
				Screen_hdc = GetDC(NULL);
				bDragDock = TRUE;
				bDragIcon = FALSE;
				OffLeft = OldLeft; // Save offset of mouse
				OffTop = OldTop; // from top left of rect
				MoveRect.left   = DockOptions.DockLeft;
				MoveRect.top    = DockOptions.DockTop;
				if(DockOptions.Position == DOCK_HORZ){
					MoveRect.bottom = MoveRect.top + SLOT_BUTTON_HEIGHT;
					MoveRect.right  = MoveRect.left + DockOptions.DockSize*SLOT_BUTTON_HEIGHT;
				}
				else{
					MoveRect.bottom = MoveRect.top + DockOptions.DockSize*SLOT_BUTTON_HEIGHT;
					MoveRect.right  = MoveRect.left + SLOT_BUTTON_WIDTH;
				}
				DrawFocusRect( Screen_hdc, &MoveRect );
            }
            else{
                bDragDock = FALSE;
                bDragIcon = FALSE;
                bRemoveSlot = FALSE;
            }
            return 0;

        case WM_LBUTTONUP:
            ReleaseCapture();
			if (bDragDock){
				DrawFocusRect( Screen_hdc, &MoveRect ); // Erase old frame
				bDragDock = FALSE;

				DockOptions.DockLeft += ((short int)LOWORD(lParam) - OffLeft);
				DockOptions.DockTop += ((short int)HIWORD(lParam) - OffTop);
				SetDockWinPos( DockOptions.Position + QX_HORZ ); // Move Dock to new position

				sprintf(TmpBuffer, "%d", DockOptions.DockLeft);
				WritePrivateProfileString("Main Options", "DockLeft", TmpBuffer, IniFile);
				sprintf(TmpBuffer, "%d", DockOptions.DockTop);
				WritePrivateProfileString("Main Options", "DockTop", TmpBuffer, IniFile);
				ReleaseDC(NULL, Screen_hdc);
				UpdateINIFile( &Slot[0] );	// Update Position entry in ini file
			}
			else if( bDragIcon ){
                if(bSlotMove){
                    Win_hdc = GetDC(hwnd);
					BitBlt( Win_hdc, OldLeft-19, OldTop-19, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                        hdcUnderIcon, 0, 0, SRCCOPY);
                    ReleaseDC(hwnd, Win_hdc);
				}

				// Reset Slot status flag to true state;
                Slot[OrigSlot].SlotType = SLOT_USED;

                SlotHit = FindSlotHit(DockOptions.Position, LOWORD(lParam), HIWORD(lParam));
                if(bRemoveSlot){
                	UtilEmptySlot( &Slot[OrigSlot] );
					UpdateINIFile( &Slot[OrigSlot] );	// Delete entry in ini file
                    if(bSlotMove)
                        RePaintSlot(OrigSlot, TRUE);
                }
                else if (SlotHit != OrigSlot){   // if the slot actually moved

                    if( (Slot[SlotHit].SlotType == SLOT_USED) ||
                    	(Slot[SlotHit].SlotType == SLOT_FREE)){

						SwapSlots( &Slot[OrigSlot], &Slot[SlotHit] );

                        if(bSlotMove)
                            RePaintSlot( OrigSlot, FALSE );
                    }
                    else {   // Slot must be a special, can't move a slot to here.
//                        Slot[OrigSlot].SlotType = SLOT_USED;
                        if(bSlotMove)
                            RePaintSlot( OrigSlot, FALSE );
                    }

					UpdateINIFile( &Slot[SlotHit] );	// Update entry in ini file
					UpdateINIFile( &Slot[OrigSlot] );	// Update entry in ini file
                }
				else{
					RePaintSlot( SlotHit, FALSE );
				}

                if(bSlotMove){
                    RePaintSlot(SlotHit-1, TRUE);
                    RePaintSlot(SlotHit, TRUE);
                    RePaintSlot(SlotHit+1, TRUE);
                }
                else{
                    /*******************************************
                        Slot did not move, so treat this
                        as a single left click message &
                        run the app, if SingleClickStart
                        is TRUE
                    *******************************************/
                    if( DockOptions.SingleClickStart ){
                        SendMessage( hwnd, WM_LBUTTONDBLCLK, wParam, lParam );
                    }
                }
                ShowCursor(TRUE);
                bDragIcon = FALSE;
            }
            return 0;

        case WM_MOUSEMOVE:
			if (bDragDock){
				DrawFocusRect( Screen_hdc, &MoveRect ); // Erase old frame
				OldLeft = (short int)LOWORD(lParam);
				OldTop  = (short int)HIWORD(lParam);
				MoveRect.left   = (DockOptions.DockLeft + OldLeft) - OffLeft;
				MoveRect.top    = (DockOptions.DockTop + OldTop) - OffTop;

                {
                    static FILE *fp = NULL;
                    if(fp == NULL ){
                     fp = fopen( "C:\\OUT", "w" );
                    }
                    fprintf(fp, "Old.left = %d\tOld.top = %d\n", OldLeft, OldTop );
                    fprintf(fp, "Off.left = %d\tOff.top = %d\n", OffLeft, OffTop );
                    fprintf(fp, "Rect.left = %d\tRect.top = %d\n", MoveRect.left, MoveRect.top );
                    fflush(fp);
                }

				if(DockOptions.Position == DOCK_HORZ){
					MoveRect.bottom = MoveRect.top + SLOT_BUTTON_HEIGHT;
					MoveRect.right  = MoveRect.left + DockOptions.DockSize*SLOT_BUTTON_HEIGHT;
				}
				else{
					MoveRect.bottom = MoveRect.top + DockOptions.DockSize*SLOT_BUTTON_HEIGHT;
					MoveRect.right  = MoveRect.left + SLOT_BUTTON_WIDTH;
				}
				DrawFocusRect( Screen_hdc, &MoveRect );
			}
			else if(bDragIcon){
                if( IsCursorOutOfDock( (int)LOWORD(lParam), (int)HIWORD(lParam)) ){
                    if(!bRemoveSlot){
                        bSlotOffDock = FALSE;
                        bRemoveSlot = TRUE;
                        ShowCursor(TRUE);
                        hRemCur = LoadCursor(hAppInst, "RemoveSlot");
                        SetCursor( hRemCur );
                    }
                    if(bSlotOffDock) return(TRUE);
                }
                else if(bRemoveSlot){
                    bRemoveSlot = FALSE;
                    SetCursor(LoadCursor(NULL, IDC_ARROW));
                    ShowCursor(FALSE);
                    DestroyCursor(hRemCur);
                }

                if( !bSlotMove ){
                    Win_hdc = GetDC(hwnd);

					/******************************************
                         Paint the area under the blank slot
                    ******************************************/
					BlankSlot( Win_hdc, OrigSlot );

                    /*****************************************
                    Copy what will be under the Icon
                    *****************************************/
                    BitBlt( hdcUnderIcon, 0, 0, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                        Win_hdc, OldLeft-19, OldTop-19, SRCCOPY);
                    /********************
                        Draw the Icon
                    ********************/
                    UtilDrawIcon(Win_hdc, &Slot[OrigSlot], OldLeft-19, OldTop-19);

                    ReleaseDC(hwnd, Win_hdc);
					bSlotMove = TRUE;
                    bDragIcon = TRUE;
                    return(TRUE);
                }

                /*****************************************************************
                    The following is an attempt at getting flicker free dragging
                    of a slot around the dock, third buffer required to eliminate
                    trailing/leading edge flicker when dragging
                *****************************************************************/
                NewX = LOWORD(lParam);
                NewY = HIWORD(lParam);
                Win_hdc = GetDC(hwnd);
				// Blit what will be covered to Tmp
                BitBlt( hdcNewUnderIcon, 0, 0, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                    Win_hdc, NewX-19, NewY-19, SRCCOPY);

                // Blit UnderIcon to old-new in tmp
                BitBlt( hdcNewUnderIcon, (OldLeft)-NewX, (OldTop)-NewY, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                    hdcUnderIcon, 0, 0, SRCCOPY);

                // Draw complete Icon into buffer & then blit to screen
                UtilDrawIcon( hdcTmp, &Slot[OrigSlot], 0, 0 );

                // Draw Icon into Under Icon Bmp at new-old
                UtilDrawIcon( hdcUnderIcon, &Slot[OrigSlot], NewX-(OldLeft), NewY-(OldTop));

                // Blit complete icon to screen
                BitBlt( Win_hdc, NewX-19, NewY-19, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                    hdcTmp, 0, 0, SRCCOPY);

                // Replace what was covered by the icon, and is not covered by new pos
                BitBlt( Win_hdc, (OldLeft-19), (OldTop-19), SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                    hdcUnderIcon, 0, 0, SRCCOPY);

                // Save new image of what's under the icon.
                BitBlt( hdcUnderIcon, 0, 0, SLOT_BUTTON_WIDTH, SLOT_BUTTON_HEIGHT,
                    hdcNewUnderIcon, 0, 0, SRCCOPY);

                // Save new posn
                OldLeft = NewX;
                OldTop = NewY;

                if(!bSlotOffDock) bSlotOffDock = TRUE;
                ReleaseDC(hwnd, Win_hdc);
			}
            return 0;


        case WM_LBUTTONDBLCLK:
            /*******************************************************************
               First need to calculate which button has been hit, by dividing
               the y coordinate by the height of the buttons and subtracting
               the number of special buttons operational and 1 for the title
               Icon.
            *******************************************************************/

            SlotHit = FindSlotHit(DockOptions.Position, LOWORD(lParam), HIWORD(lParam));

            switch (Slot[SlotHit].SlotType) {
                case SLOT_USED:
					RePaintSlot(SlotHit, FALSE);
                    ExecSlot( SlotHit, Slot[SlotHit].CmdLine );
                    break;

                case SLOT_SPECIAL_MAIL:
                	DockOptions.bMailInBox = FALSE;
                    UtilLoadIcon( &Slot[SlotHit] );
                    RePaintSlot(SlotHit, FALSE);
                    break;

                case SLOT_SPECIAL_EXIT:
                    if (DockOptions.WinExitConfirm) {
                        nItem = MessageBox(hwnd, "Do you really want to exit Windows ?",
                            "FreeDock", MB_OKCANCEL | MB_ICONSTOP);
                        if (nItem == IDOK) {
                            ExitWindows(0, 0);
                        }
                    } 
                    else {
                        ExitWindows(0, 0);
                    }
                    break;

                case SLOT_SPECIAL_TITLE:
                    DialogBox(hInst, "ABOUTDOCKDLG", hwnd, lpfnAboutDockDlgProc);
                    break;

            }
            return 0;

        case WM_DROPFILES:
            hDrop = (HANDLE)wParam;

            /***********************************************************
               Find out if the drop point was in the client area.
               This must be the case, or an error has occurred.
            ***********************************************************/
			if( ! DragQueryPoint(hDrop, (LPPOINT)&DropPoint) ){
            	sprintf(TmpBuffer, "Error Occurred : DockWinProc()\n(WM_DROPFILES, Drop point not in client area).");
            	MessageBox(hwnd, TmpBuffer, "FreeDock", MB_OK | MB_ICONSTOP);
				break;
			}

            /*******************************************
                Find out how many files were dropped
            *******************************************/
            nNumDropped = DragQueryFile(hDrop, -1, (LPSTR)NULL, 0);

			if( nNumDropped < 1 ){
            	sprintf(TmpBuffer, "Error Occurred : DockWinProc()\n(WM_DROPFILES, DragQuery returned %d).", nNumDropped);
            	MessageBox(hwnd, TmpBuffer, "FreeDock", MB_OK | MB_ICONSTOP);
				break;
			}

            SlotHit = FindSlotHit(DockOptions.Position, DropPoint.x, DropPoint.y);

            switch (Slot[SlotHit].SlotType) {

                case SLOT_USED:
                    /***********************************************************
                        Build up the command line and then call the ExecSlot
                        function to execute the associated program
                    ***********************************************************/
                    sprintf(CommandLine, "%s ", Slot[SlotHit].CmdLine);
                    for (FileIndex = 0; FileIndex < nNumDropped; FileIndex++) {
                        DragQueryFile(hDrop, FileIndex, DroppedFileName, MAX_FPATH_LEN);
                        /************************************************
                            Check if this file has an extension, if not
                            add a trailing '.'
                        ************************************************/
                        if (!strchr(&DroppedFileName[strlen(DroppedFileName) - 4], '.')) {
                            DroppedFileName[strlen(DroppedFileName) + 1] = '\0';
                            DroppedFileName[strlen(DroppedFileName)] = '.';
                        }

						// Add Filename to Commandline if it will fit
						if( (strlen(CommandLine) + strlen(DroppedFileName)+1) < MAX_CMDLINE_LEN ) {
                        	strcat(CommandLine, DroppedFileName);
                        	strcat(CommandLine, " ");
						}
						else{
            			    MessageBox(hwnd, "Too many files dropped to fit on application command line, ignoring extras.",
                 			           "FreeDock Error", MB_OK | MB_ICONSTOP);
						 	break;
						}
                    }

                    ExecSlot( SlotHit, CommandLine );

                    break;

                case SLOT_FREE:
                    nDropSlot = SlotHit;
                    SlotIndex = SlotHit;
                    for (FileIndex = 0; FileIndex < nNumDropped; FileIndex++) {
                        DragQueryFile(hDrop, FileIndex, DroppedFileName, MAX_FPATH_LEN);
                        Slot[SlotIndex].SlotType = SLOT_USED;
                        Slot[SlotIndex].StartState = START_NORMAL;
                        Slot[SlotIndex].WinX = DEF_STORE_X;
                        Slot[SlotIndex].WinY = DEF_STORE_Y;
                        Slot[SlotIndex].WinWidth = DEF_STORE_W;
                        Slot[SlotIndex].WinHeight = DEF_STORE_H;
                        strcpy(Slot[SlotIndex].AppName, DroppedFileName);
                        strcpy(Slot[SlotIndex].RunTimeDir, DroppedFileName);
                        strcpy(Slot[SlotIndex].IconFile, DroppedFileName);
                        Slot[SlotIndex].IconPos = 0;

                        /************************************************
                           Set Run Time Dir to be same path as filename
                        ************************************************/
                        TmpCharPtr = strrchr(Slot[SlotIndex].RunTimeDir, '\\');
                        if (*(TmpCharPtr-1) == ':')
                            *(TmpCharPtr+1) = '\0';
                        else
                            *TmpCharPtr = '\0';

                        /*****************************************************************
                           Check What type of file has been dropped, is it a .PIF, .COM
                           or a .BAT ?
                        *****************************************************************/
                        if (!stricmp(&DroppedFileName[strlen(DroppedFileName) - 4], ".PIF") ||
                            !stricmp(&DroppedFileName[strlen(DroppedFileName) - 4], ".COM") ||
                            !stricmp(&DroppedFileName[strlen(DroppedFileName) - 4], ".BAT")) {


		                    Status = (UINT)FindExecutable("progman.exe",
    		                                              NULL,
        		                                          Slot[SlotIndex].IconFile);
            		        if( Status <= 31 ){
                		            MessageBox(hwnd, "Program Manager not found, cannot select default Icon.",
                    		                   "FreeDock Error", MB_OK | MB_ICONSTOP);
		                    }
                            Slot[SlotIndex].IconPos = 1;
                            // Load the Icon into the slot's own bitmap
                            UtilLoadIcon( &Slot[SlotIndex] );
                        }
                        /******************************************************************
                            Is is a .EXE, if so is it a Windows EXE or a DOS EXE ?
                        ******************************************************************/
                        else if (!stricmp(&DroppedFileName[strlen(DroppedFileName) - 4], ".EXE")) {
                            // Load the Icon into the slot's own bitmap
                            UtilLoadIcon( &Slot[SlotIndex] );
                            if (Slot[SlotIndex].IconTotal == 0) {

			                    Status = (UINT)FindExecutable("progman.exe",
    			                                              NULL,
        			                                          Slot[SlotIndex].IconFile);
            			        if( Status <= 31 ){
                			            MessageBox(hwnd, "Program Manager not found, cannot select default Icon.",
                    			                   "FreeDock Error", MB_OK | MB_ICONSTOP);
		                    	}

                                Slot[SlotIndex].IconPos = 1;
                                // Load the Icon into the slot's own bitmap
                                UtilLoadIcon( &Slot[SlotIndex] );

                            }
                        }
                        /******************************************************************
                            It must be a document file, try to find an association for it
                        ******************************************************************/
                        else {
                            strcpy(Slot[SlotIndex].CmdLine, Slot[SlotIndex].AppName);
                            // Read the executable name in,
                            // then call SearchPath to get entire path for application.
                            Status = (UINT)FindExecutable(Slot[SlotIndex].CmdLine,
                                Slot[SlotIndex].RunTimeDir,
                                Slot[SlotIndex].AppName);
                                
                            // Now call find executable to ensure we have a complete
                            // path to the application
                            if( FindExecutable(Slot[SlotIndex].AppName,
                                Slot[SlotIndex].RunTimeDir,
                                TmpBuffer) > (HINSTANCE)32 ){
	                          	strcpy( Slot[SlotIndex].AppName, TmpBuffer);
	                        }
                            
                            if (Status > 32) {
                                strcpy(Slot[SlotIndex].IconFile, Slot[SlotIndex].AppName);
                                Slot[SlotIndex].IconPos = 0;
                                // Load the Icon into the slot's own bitmap
                                UtilLoadIcon( &Slot[SlotIndex] );
                            } 
                            else {
                                sprintf(TmpBuffer, "%s\nis not an executable or an associated file", Slot[SlotIndex].CmdLine);
                                MessageBox(hwnd, TmpBuffer, "FreeDock", MB_OK | MB_ICONSTOP);
                                Slot[SlotIndex].SlotType = SLOT_FREE;
                            }
                        }

                        RePaintSlot(SlotIndex, FALSE);

                        UpdateINIFile(&Slot[SlotIndex]);    // Save the new slot

                        SlotIndex++;
                        while ((SlotIndex != nDropSlot) && (Slot[SlotIndex].SlotType != SLOT_FREE)) {
                            SlotIndex++;
                            if (SlotIndex >= DockOptions.DockSize)
                                SlotIndex = 1;
                        }
                        if (SlotIndex == nDropSlot)
                            break;
                    }
                    break;

            }

            DragFinish(hDrop);

            return 0;

        case WM_RBUTTONDOWN:
            /*************************************************
              If we are currently dragging a slot around
              then ignore any buttons being pressed
          *************************************************/
            if( bDragIcon ) return 0;

            SlotHit = FindSlotHit(DockOptions.Position, LOWORD(lParam), HIWORD(lParam));

            switch (Slot[SlotHit].SlotType) {
                case SLOT_USED:
                case SLOT_FREE:
                    CurSlot = SlotHit;  /* set global index to target slot */
                    Status = DialogBox(hInst, "APPOPTIONSDLG", hwnd, lpfnAppOptionsDlgProc);
                    if(Status) UpdateINIFile(&Slot[SlotHit]);
                    break;

                case SLOT_SPECIAL_TITLE:
                    Status = DialogBox(hInst, "MAINOPTIONSDLG", hwnd, lpfnMainOptionsDlgProc);
                    if(Status) UpdateINIFile(&Slot[0]);
                    break;

                case SLOT_SPECIAL_EXIT:
                    Status = DialogBox(hInst, "WINEXITOPTIONSDLG", hwnd, lpfnWinExitOptionsDlgProc);
                    if(Status) UpdateINIFile(&Slot[0]);
                    break;

                case SLOT_SPECIAL_MAIL:
                    Status = DialogBox(hInst, "MAILOPTIONSDLG", hwnd, lpfnMailOptionsDlgProc);
                    if(Status) UpdateINIFile(&Slot[0]);
                    break;

                case SLOT_SPECIAL_CLOCK:
                    Status = DialogBox(hInst, "CLOCKOPTIONSDLG", hwnd, lpfnClockOptionsDlgProc);
                    if(Status) UpdateINIFile(&Slot[0]);
                    break;
            }

            return 0;


        case WM_CLOSE:
//            WriteINIFile(Slot);
            DestroyWindow(hwnd);
			return 0;

        case WM_QUIT:
        case WM_DESTROY:
//            WriteINIFile(Slot);
            FreeProcInstance(lpfnAppOptionsDlgProc);
            FreeProcInstance(lpfnAboutDockDlgProc);
            FreeProcInstance(lpfnWinExitOptionsDlgProc);
            FreeProcInstance(lpfnMailOptionsDlgProc);
            FreeProcInstance(lpfnMainOptionsDlgProc);
            FreeProcInstance(lpfnClockOptionsDlgProc);
            KillTimer(hwndDock, MAIL_TIMER);
            /**************************************
            	Release all the Device Contexts
            	and bitmaps used
            **************************************/
            SelectObject(DockOptions.hdcIconCache, hbmOldIconCache);
			SelectObject(hdcUnderIcon,             hbmOldUnderIcon);
            SelectObject(hdcNewUnderIcon,          hbmOldNewUnderIcon);
            SelectObject(hdcTmp,                   hbmOldTmp);

            Status = 0;
            
			Status += DeleteObject(hbmUnderIcon);
            Status += DeleteObject(hbmNewUnderIcon);
            Status += DeleteObject(hbmTmp);
            Status += DeleteObject(DockOptions.hbmIconCache);
			Status += DeleteDC(hdcUnderIcon);
            Status += DeleteDC(hdcNewUnderIcon);
            Status += DeleteDC(hdcTmp);
			Status += DeleteDC(DockOptions.hdcIconCache);
            
			if( Status != 0 ){
		      	MessageBox(hwnd, "Error releasing Resources, you may need to restart Windows.", 
		      			   "FreeDock Resource Error", MB_OK | MB_ICONSTOP);
        	}    

            free(Slot);
            PostQuitMessage(0);
			return 0;
    }

    /* return all unused mesages to the system */
    return DefWindowProc(hwnd, message, wParam, lParam);
}
