/****************************************************************************

    FUNCTION: ROEditWinProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam)

    VERSION : v1.0
                      
    PURPOSE : To provide a READ ONLY verision of the standard Windows
              class, the EDIT CONTROL. This is done by replacing the
              standard window Proc for the EDIT CONTROL, with a new one
              which ignores mouse and keyboard input.

    MESSAGES: The following input messages are trapped and their effects
              ignored :
                  WM_KEYDOWN
                  WM_CHAR
                  WM_MOUSEMOVE
                  WM_LBUTTONDOWN
                  WM_RBUTTONDOWN
                  WM_RBUTTONUP
                  WM_MBUTTONDOWN
                  WM_MBUTTONUP
                  WM_SETCURSOR

    COMMENTS:

****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <windows.h>
#include "freedock.h"
#include "debug.h"

/***************************************************************
	This module is only compiled if debugging is activated
***************************************************************/

#ifdef DEBUGGING_ON

extern FARPROC  pDefEditWndFn;	    /* defined in proto.c */

LONG PASCAL FAR ROEditWinProc(HWND hwnd, WORD wMsg, WORD wParam, LONG lParam)
{
    LONG            lRVal = 0L;
    BOOL            bCWP = FALSE;

    switch (wMsg) {
    case WM_KEYDOWN:		/* trap all these messages */
    case WM_CHAR:
    case WM_MOUSEMOVE:
    case WM_LBUTTONDOWN:
    case WM_RBUTTONDOWN:
    case WM_RBUTTONUP:
    case WM_MBUTTONDOWN:
    case WM_MBUTTONUP:
	break;

    case WM_SETCURSOR:		/* trap client-area messages */
	bCWP = (LOWORD(lParam) != HTCLIENT);
	break;

    default:
	bCWP = TRUE;
	break;
    }

    if (bCWP)
	lRVal = CallWindowProc(pDefEditWndFn, hwnd, wMsg, wParam, lParam);

    return lRVal;
}

#define ROEDITID     2		/* child window ID number */

long FAR PASCAL DebugWinProc(HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    extern HWND     hwndSubDebug;

	PAINTSTRUCT		psDebugWin;
    static int      SubDebug_X, SubDebug_Y; /* origin of child window */
	static int		TextHeight;				/* height of label text */
    static HANDLE   hInst;            		/* application instance handle */
		   HDC		hdcDebugWin;

    switch (message) {
        case WM_CREATE:
    	    hInst = ((LPCREATESTRUCT) lParam) -> hInstance;
			TextHeight = 20;
    	    SubDebug_X = 0;      /* define position of child window */
	        SubDebug_Y = (gIconHeight*2) + (TextHeight*2);
	        /* setup child window text limit */
    	    SendMessage(hwndSubDebug, EM_LIMITTEXT, DEBUG_BUF_SIZE, 0L);
		    /* ensure text is formatted correctly */
    	    SendMessage(hwndSubDebug, EM_FMTLINES, TRUE, 0L);
			/* Setup Initial Contents */
			UpdateDebugWindow(hwndSubDebug);
	    return 0;

        case WM_SIZE:   /* size of parent has changed, so need to resize child */
	        MoveWindow(hwndSubDebug, SubDebug_X, SubDebug_Y,
		               LOWORD(lParam), HIWORD(lParam) - SubDebug_Y, TRUE);
	    return 0;

		case WM_LBUTTONUP:
			/* Update Contents */
			UpdateDebugWindow(hwndSubDebug);
		return 0;

        case WM_PAINT:
			hdcDebugWin = BeginPaint(hwnd, &psDebugWin);

			if( !IsIconic(hwnd) ){

			    BitBlt( hdcDebugWin, 0, TextHeight, 
			    					 ((gIconWidth * (DOCK_MAX_SIZE+1))/2), gIconHeight, 
        	    DockOptions.hdcIconCache, 0, 0, SRCCOPY);
  				
			    BitBlt( hdcDebugWin, 0, gIconHeight+TextHeight,
			     					 ((gIconWidth * (DOCK_MAX_SIZE+1))/2), gIconHeight, 
        	    DockOptions.hdcIconCache, ((gIconWidth * (DOCK_MAX_SIZE+1))/2), 0, SRCCOPY);

				TextOut( hdcDebugWin, 0, 0, "Icon Cache", 
									 strlen("Icon Cache") );

				TextOut( hdcDebugWin, 0, (gIconHeight*2+TextHeight), "Dock & Slot Data Structures. (Click Here to Update)", 
										 					  strlen("Dock & Slot Data Structures. (Click Here to Update)") );
			}

			EndPaint( hwnd, &psDebugWin );
        return 0;


        case WM_CLOSE:  /* intercept close message */
    	    ShowWindow(hwnd, SW_SHOWMINNOACTIVE);
	        UpdateWindow(hwnd);
	    return 0;
    }
        /* return all unprocess messages to the system */
    return DefWindowProc(hwnd, message, wParam, lParam);
}


void UpdateDebugWindow( HWND hwndSubDebug ){
 	
	char TmpBuffer[MAX_FPATH_LEN];
	int  i;

	/* Hide window whilst setting up text, makes it much faster */
	ShowWindow( hwndSubDebug, SW_HIDE );

   	SendMessage(hwndSubDebug, EM_SETSEL, 0, MAKELONG(0, 32767));
    SendMessage(hwndSubDebug, EM_REPLACESEL, 0,
			    (long)"DockOptions Structure\r\r\n==================\r\r\n");

    sprintf( TmpBuffer, "DockOptions.Position         = %d\r\r\n", DockOptions.Position );
    SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.DockSize         = %d\r\r\n", DockOptions.DockSize );
  	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.DockLeft         = %d\r\r\n", DockOptions.DockLeft );
   	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.DockTop          = %d\r\r\n", DockOptions.DockTop );
   	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.ClockActive      = %d\r\r\n", DockOptions.ClockActive );
   	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.WinExitActive    = %d\r\r\n", DockOptions.WinExitActive );
   	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.MailActive       = %d\r\r\n", DockOptions.MailActive );
   	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.MaxView          = %d\r\r\n", DockOptions.MaxView );
   	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.AlwaysOnTop      = %d\r\r\n", DockOptions.AlwaysOnTop );
   	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.SingleClickStart = %d\r\r\n", DockOptions.SingleClickStart );
	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.MailPath         = %s\r\r\n", DockOptions.MailPath );
	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.MailFreq         = %d\r\r\n", DockOptions.MailFreq );
	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.MailSound        = %d\r\r\n", DockOptions.MailSound );
	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.MailBoxSize      = %d\r\r\n", DockOptions.MailBoxSize );
	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.MailBoxDateTime  = %d\r\r\n", DockOptions.MailBoxDateTime );
	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.bMailInBox       = %d\r\r\n", DockOptions.bMailInBox );
	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
    sprintf( TmpBuffer, "DockOptions.WinExitConfirm   = %d\r\r\n", DockOptions.WinExitConfirm );
	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);


    sprintf( TmpBuffer, "\r\r\n\r\r\n=====\r\r\nSlots\r\r\n=====\r\r\n" );
  	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);


	for( i=0; i < DOCK_MAX_SIZE; i++ ){
	
	    sprintf( TmpBuffer, "\r\r\nSlot[%2d]\r\r\n========\r\r\n", i );
    	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "SlotType   = %d\r\r\n", Slot[i].SlotType );                 
	    SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "ID         = %d\r\r\n", Slot[i].ID );                       
    	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "AppName    = %s\r\r\n", Slot[i].AppName );
	    SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "CmdLine    = %s\r\r\n", Slot[i].CmdLine );
    	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "RunTimeDir = %s\r\r\n", Slot[i].RunTimeDir );
	    SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "StartState = %d\r\r\n", Slot[i].StartState );
    	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "StartOnTop = %d\r\r\n", Slot[i].StartOnTop );               
	    SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "WinX       = %d\r\r\n", Slot[i].WinX );                     
    	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "WinY       = %d\r\r\n", Slot[i].WinY );                     
	    SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "WinWidth   = %d\r\r\n", Slot[i].WinWidth );                 
    	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "WinHeight  = %d\r\r\n", Slot[i].WinHeight );                
	    SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "IconFile   = %s\r\r\n", Slot[i].IconFile );  
    	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "IconPos    = %d\r\r\n", Slot[i].IconPos );                  
	    SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "IconTotal  = %d\r\r\n", Slot[i].IconTotal );                
    	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
        sprintf( TmpBuffer, "IconIndex  = %d\r\r\n", Slot[i].IconIndex );                
    	SendMessage(hwndSubDebug, EM_REPLACESEL, 0, (LONG) TmpBuffer);
	}				

	ShowWindow( hwndSubDebug, SW_SHOW );
}

#endif
