/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#include <rhide.h>

#define Uses_tvutilFunctions
#include <libtvuti.h>

#include <limits.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

static char *default_env_dirs[] = {
#ifdef DEFAULT_ENV_DIRS
DEFAULT_ENV_DIRS
#else
#ifdef __linux__
 "/lib/rhide",
 "/local/lib/rhide",
 "/usr/lib/rhide",
 "/usr/local/lib/rhide",
 "/usr/share/rhide",
 "/usr/local/share/rhide",
#endif
#ifdef __DJGPP__
 "/share/rhide",
#endif
#endif
 NULL };

static int _rhide_load_environment_file(char *fname);

void rhide_load_environment_file(char *app,char *name)
{
  char fname[PATH_MAX];
  char **dname;
#ifdef __DJGPP__
  char *djgpp = getenv("DJDIR");
#else
  char *home;
#endif
  // try at first all the DEFAULT_ENV_DIRS
  for (dname = default_env_dirs;*dname;dname++)
  {
    fname[0] = 0;
#ifdef __DJGPP__
    if (djgpp)
      strcat(fname,djgpp);
#endif
    strcat(fname,*dname);
    strcat(fname,"/");
    strcat(fname,app);
    strcat(fname,"/");
    strcat(fname,name);
    _rhide_load_environment_file(fname);
  }
#ifndef __DJGPP__
  home = getenv("HOME");
  if (home)
  {
    strcpy(fname,home);
    strcat(fname,"/");
    strcat(fname,name);
    _rhide_load_environment_file(fname);
  }
#endif
  _rhide_load_environment_file(name);
}

/*
  This reads in an environment file. The syntax of that file
  is very simple. Normally it contains only lines like

VARIABLE=CONTENTS

  which means, that VARIABLE should become the contents
  CONTENTS.
  In addition to this, the file can have some special
  things.
  1) A line, which begins with # is a comment
  2) A line, which begins with a dot, means, read
     here the file, with the name, which starts after
     the dot.
  3) A line, which begins with ! tells RHIDE, to put
     this variable also in the environment with
     putenv().
*/

static int
_rhide_load_environment_file(char *fname)
{
  FILE *f;
  char line[2048];
  char *variable;
  f = fopen(fname,"rt");
  if (!f) return 0;
  while (fgets(line,2048,f))
  {
    if (line[0] == '#') // comment
      continue;
    line[strlen(line)-1] = 0; // remove the last '\n'
    if (line[0] == '.') // include a file
    {
      char *_fname = expand_spec(line+1,NULL);
      _rhide_load_environment_file(_fname);
      string_free(_fname);
      continue;
    }
    int _putenv = 0;
    variable = line;
    if (line[0] == '!')
    {
      _putenv = 1;
      variable++;
    }
    char *equal = strchr(line,'=');
    if (equal)
    {
      *equal = 0;
      insert_variable(variable,equal+1);
#ifdef __linux__
/* That's now a special case, when running under linux
  using ncurses. There is this variable used, but only
  at startup, which is already done */
      if (strcmp(variable,"ESCDELAY") == 0)
      {
        extern int ESCDELAY;
        ESCDELAY = atoi(equal+1);
      }
#endif
      if (_putenv)
      {
        *equal = '=';
        putenv(string_dup(variable));
      }
    }
  }
  fclose(f);
  return 1;
}


