/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Black 0
#define Blue 1
#define Green 2
#define Cyan 3
#define Red 4
#define Magenta 5
#define Brown 6
#define Lightgray 7
#define Darkgray 8
#define Lightblue 9
#define Lightgreen A
#define Lightcyan B
#define Lightred C
#define Lightmagenta D
#define Yellow E
#define White F

#define __S(color) #color
#define _S(bg,fg) __S(\x##bg##fg)
#define S(index,foreground,background,comment...) _S(background,foreground)

/* This is the palette for the system when in color mode */
#define cpRHGDBColor\
        S( 1,Blue,Lightgray,background) \
        \
        S( 2,Black,Lightgray,normal text, Used by menus and statusline) \
        S( 3,Darkgray,Lightgray,disabled text) \
        S( 4,Red,Lightgray,shortcut) \
        S( 5,Black,Green,normal selected) \
        S( 6,Darkgray,Green,disabled selected) \
        S( 7,Red,Green,shortcut selected) \
        \
        S( 8,Lightgray,Blue,passive frame, Used by blue windows ) \
        S( 9,White,Blue,active frame) \
        S( A,Lightgreen,Blue,frame icons) \
        S( B,Blue,Cyan,scrollbar) \
        S( C,Blue,Cyan,scrollbar icons) \
        S( D,Yellow,Blue,normal text) \
        S( E,Blue,Lightgray,selected text) \
        \
        S( F,Black,Black,reserved) \
        \
        S(10,Lightgray,Cyan,passive frame, Used by cyan windows ) \
        S(11,White,Cyan,active frame) \
        S(12,Lightgreen,Cyan,frame icons) \
        S(13,Cyan,Blue,scrollbar) \
        S(14,Cyan,Blue,scrollbar icons) \
        S(15,Yellow,Cyan,normal text) \
        S(16,Blue,Green,selected text) \
        \
        S(17,Black,Black,reserved) \
        \
        S(18,Lightgray,Black,passive frame, Used by gray windows ) \
        S(19,White,Black,active frame) \
        S(1A,White,Black,frame icons) \
        S(1B,Lightgray,Black,scrollbar) \
        S(1C,White,Black,scrollbar icons) \
        S(1D,Lightgray,Black,normal text) \
        S(1E,Black,Lightgray,selected text) \
        \
        S(1F,Black,Black,reserved) \
        \
        S(20,Black,Lightgray,passive frame, Used by dialogs) \
        S(21,White,Lightgray,active frame) \
        S(22,Lightgreen,Lightgray,frame icons) \
        S(23,Cyan,Blue,scrollbar) \
        S(24,Cyan,Blue,scrollbar icons) \
        S(25,Black,Lightgray,static text) \
        S(26,Black,Lightgray,label normal) \
        S(27,White,Lightgray,label selected) \
        S(28,Yellow,Lightgray,label shortcut) \
        S(29,Black,Green,button normal) \
        S(2A,Lightcyan,Green,button default) \
        S(2B,White,Green,button focused) \
        S(2C,Darkgray,Lightgray,butten disabled) \
        S(2D,Yellow,Green,button shortcut) \
        S(2E,Black,Lightgray,button shadow) \
        S(2F,Black,Cyan,cluster normal) \
        S(30,White,Cyan,cluster selected) \
        S(31,Yellow,Cyan,cluster shortcut) \
        S(32,White,Blue,inputline normal) \
        S(33,White,Green,inputline selected) \
        S(34,Lightgreen,Blue,inputline arrows) \
        S(35,Black,Green,history arrow) \
        S(36,Green,Lightgray,history side) \
        S(37,Blue,Cyan,history window scrollbar) \
        S(38,Blue,Cyan,history window scrollbar icons) \
        S(39,Black,Cyan,list normal) \
        S(3A,White,Green,list focused) \
        S(3B,Yellow,Cyan,list selected) \
        S(3C,Blue,Cyan,list divider) \
        S(3D,Cyan,Blue,infopane) \
        \
        S(3E,Black,Black,reserved) \
        S(3F,Black,Black,reserved) \
        S(40,Black,Cyan,CPU line) \
        S(41,White,Red,breakpoint)

#define Normal 07
#define Light 0F
#define Inverse 70
#define Underline 01
#define Empty 00

#define __M(color) #color
#define _M(col) __M(\x##col)
#define M(index,color,comment...) _M(color)

/* This is the palette for the system when in monochrome mode */
#define cpRHGDBMono\
        M( 1,Normal,background) \
        \
        M( 2,Normal,normal text, Used by menus and statusline) \
        M( 3,Normal,disabled text) \
        M( 4,Underline,shortcut) \
        M( 5,Inverse,normal selected) \
        M( 6,Underline,disabled selected) \
        M( 7,Inverse,shortcut selected) \
        \
        M( 8,Normal,passive frame, Used by blue windows ) \
        M( 9,Light,active frame) \
        M( A,Normal,frame icons) \
        M( B,Normal,scrollbar) \
        M( C,Normal,scrollbar icons) \
        M( D,Normal,normal text) \
        M( E,Inverse,selected text) \
        \
        M( F,Empty,reserved) \
        \
        M(10,Normal,passive frame, Used by blue windows ) \
        M(11,Light,active frame) \
        M(12,Normal,frame icons) \
        M(13,Normal,scrollbar) \
        M(14,Normal,scrollbar icons) \
        M(15,Normal,normal text) \
        M(16,Inverse,selected text) \
        \
        M(17,Empty,reserved) \
        \
        M(18,Normal,passive frame, Used by blue windows ) \
        M(19,Light,active frame) \
        M(1A,Normal,frame icons) \
        M(1B,Normal,scrollbar) \
        M(1C,Normal,scrollbar icons) \
        M(1D,Normal,normal text) \
        M(1E,Inverse,selected text) \
        \
        M(1F,Empty,reserved) \
        \
        M(20,Normal,passive frame, Used by dialogs) \
        M(21,Light,active frame) \
        M(22,Normal,frame icons) \
        M(23,Normal,scrollbar) \
        M(24,Normal,scrollbar icons) \
        M(25,Normal,static text) \
        M(26,Normal,label normal) \
        M(27,Inverse,label selected) \
        M(28,Underline,label shortcut) \
        M(29,Inverse,button normal) \
        M(2A,Underline,button default) \
        M(2B,Inverse,button focused) \
        M(2C,Normal,butten disabled) \
        M(2D,Normal,button shortcut) \
        M(2E,Normal,button shadow) \
        M(2F,Inverse,cluster normal) \
        M(30,Normal,cluster selected) \
        M(31,Light,cluster shortcut) \
        M(32,Underline,inputline normal) \
        M(33,Inverse,inputline selected) \
        M(34,Normal,inputline arrows) \
        M(35,Normal,history arrow) \
        M(36,Normal,history side) \
        M(37,Normal,history window scrollbar) \
        M(38,Normal,history window scrollbar icons) \
        M(39,Inverse,list normal) \
        M(3A,Normal,list focused) \
        M(3B,Underline,list selected) \
        M(3C,Normal,list divider) \
        M(3D,Normal,infopane) \
        \
        M(3E,Empty,reserved) \
        M(3F,Empty,reserved) \
        M(40,Underline,CPU line) \
        M(41,Inverse,breakpoint) \

#define cpRHGDBBlackWhite cpRHGDBColor


