/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Uses_MsgBox
#define Uses_TApplication

#define Uses_TDirList
#define Uses_tvutilCommands
#define Uses_tvutilFunctions
#include <libtvuti.h>

#define Uses_TIDEEditWindow
#define Uses_TProject
#define Uses_TOptions
#define Uses_ideFunctions
#include <libide.h>
#include <rhide.h>

#define Uses_TEditorApp
#include <tvedit.h>

// This is for the Ctrl+ENTER feature

void OpenFileFromEditor(char *name)
{
  char *sname;
  TCEditWindow *ewindow = NULL;
  string_dup(sname,name);
  FExpand(sname);
  ewindow = is_on_desktop(sname);
  if (!ewindow)
  {
    if (messageBox(mfConfirmation | mfYesButton | mfNoButton,
                   _("Open the file %s"),sname) == cmYes)
    {
      ewindow = ((TEditorApp *)TProgram::application)->openEditor(sname,True);
    }
  }
  string_free(sname);
  if (ewindow) ewindow->select();
}

TCEditWindow *OpenEditor(const char *name,Boolean search)
{
  char *sname;
  TCEditWindow *ewindow;
  if (search == True)
#if 0
    FindFile(name,Options.SrcDirs,sname,False);
#else
    FindFile(name,sname);
#endif
  else
  {
    string_dup(sname,name);
    FExpand(sname);
  }
  ewindow = is_on_desktop(sname);
  if (!ewindow)
  { 
    ewindow = ((TEditorApp *)TProgram::application)->openEditor(sname,True);
  }
  string_free(sname);
  ewindow->select();
  return ewindow;
}


