/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#if defined( Uses_TMsgCollection ) && !defined( __TMsgCollection__ )
#define __TMsgCollection__

typedef enum {
  msgError,
  msgWarning,
  msgMessage
} msgType;

struct msg_rec
{
  char * filename;
  msgType type;
  int lineno;
  char * msg;
  msg_rec(const char *,const char *,msgType atype = msgMessage,int alineno = 0);
  ~msg_rec();
};

class TMsgCollection : public TCollection
{
public:
  TMsgCollection(void) : TCollection(5,5) {}
  virtual void freeItem(void *item);
  static const char * const name;
  static TStreamable * build();
protected:
  virtual void writeItem(void *,opstream &) {}
  virtual void *readItem(ipstream &) {return NULL;}
private:
  virtual const char * streamableName() const { return name; }
};

#endif

