#if defined( Uses_TTerminal ) && !defined( __TTerminal )
#define __TTerminal

class far TRect;
class far TScrollBar;

class TTerminal: public TTextDevice
{

public:

    TTerminal( const TRect& bounds,
	       TScrollBar *aHScrollBar,
	       TScrollBar *aVScrollBar,
	       uint32 aBufSize
	     );
    ~TTerminal();

    virtual int do_sputn( const char *s, int count );

    void bufInc( uint32& val );
    Boolean canInsert( uint32 amount );
    short calcWidth();
    virtual void draw();
    uint32 nextLine( uint32 pos );
    uint32 prevLines( uint32 pos, uint32 lines );
    Boolean queEmpty();

protected:

    uint32 bufSize;
    char *buffer;
    uint32 queFront, queBack;
    void bufDec(uint32& val);
};

#endif  // Uses_TTerminal

