#if defined( Uses_TListBox ) && !defined( __TListBox )
#define __TListBox

class far TRect;
class far TScrollBar;
class far TCollection;

class TListBox : public TListViewer
{

public:

    TListBox( const TRect& bounds, ushort aNumCols, TScrollBar *aScrollBar );
    ~TListBox();

    virtual uint32 dataSize();
    virtual void getData( void *rec );
    virtual void getText( char *dest, ccIndex item, short maxLen );
    virtual void newList( TCollection *aList );
    virtual void setData( void *rec );

    TCollection *list();

private:

    TCollection *items;

    virtual const char *streamableName() const
	{ return name; }

protected:

    TListBox( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TListBox& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TListBox*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TListBox& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TListBox* cl )
    { return os << (TStreamable *)cl; }

inline TCollection *TListBox::list()
{
    return items;
}

#endif  // Uses_TListBox

