#define Uses_MsgBox
#define Uses_TFileList
#define Uses_TRect
#define Uses_TSearchRec
#define Uses_TEvent
#define Uses_TGroup
#define Uses_TStreamableClass
#include <tv.h>

#include <dir.h>
#include <errno.h>
#include <ctype.h>
#include <assert.h>
#include <dos.h>
#include <dir.h>
#include <string.h>
#include <stdio.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fnmatch.h>

void fexpand( char * );

TFileList::TFileList( const TRect& bounds,
		      TScrollBar *aScrollBar) :
    TSortedListBox( bounds, 2, aScrollBar )
{
//  if (_USE_LFN)
    numCols = 1;
}

TFileList::~TFileList()
{
   if ( list() )
      destroy ( list() );
}

void TFileList::focusItem( ccIndex item )
{
    TSortedListBox::focusItem( item );
    message( owner, evBroadcast, cmFileFocused, list()->at(item) );
}

void TFileList::getData( void * )
{
}

void TFileList::setData( void * )
{
}

uint32 TFileList::dataSize()
{
    return 0;
}

void* TFileList::getKey( const char *s )
{
static TSearchRec sR;

    if( (shiftState & 0x03) != 0 || *s == '.' )
        sR.attr = FA_DIREC;
    else
        sR.attr = 0;
    strcpy( sR.name, s );
//    strupr( sR.name );
    return &sR;
}

void TFileList::getText( char *dest, ccIndex item, short maxChars )
{
	TSearchRec *f = (TSearchRec *)(list()->at(item));

	strncpy( dest, f->name, maxChars );
	dest[maxChars] = '\0';
    if( f->attr & FA_DIREC )
	strcat( dest, DIRSEPARATOR_ );
}

void TFileList::handleEvent( TEvent & event )
{
    if( event.what == evMouseDown && event.mouse.doubleClick )
        {
        event.what = evCommand;
        event.message.command = cmOK;
        putEvent( event );
        clearEvent( event );
        }
    else
        TSortedListBox::handleEvent( event );
}

void TFileList::readDirectory( const char *dir, const char *wildCard )
{
    char path[MAXPATH];
    strcpy( path, dir );
    strcat( path, wildCard );
    readDirectory( path );
}

typedef struct TSearchRec DirSearchRec;

struct __dj_DIR {
  int num_read;
  char *name;
  int flags;
  struct ffblk ff;
  struct dirent de;
};

extern "C" size_t _file_time_stamp(unsigned);

void TFileList::readDirectory( const char *aWildCard )
{
  DIR *dir;
  struct dirent *de;
  DirSearchRec *p;
  TFileCollection *fileList = new TFileCollection( 5, 5 );
  char *wildcard = (char *)alloca(strlen(aWildCard)+1);
  strcpy(wildcard,aWildCard);
  char *slash = strrchr(wildcard,'/');
  char *path;
  if (slash)
  {
    *slash = 0;
    path = wildcard;
    if (strlen(path) == 2 && path[1] == ':')
    {
      path = (char *)alloca(4);
      strcpy(path,wildcard);
      strcat(path,"/");
    }
    slash++;
  }
  else
  {
    slash = wildcard;
    path = ".";
  }
  dir = opendir(path);
#if 0
  unsigned short __djstat_flags = _djstat_flags;
  _djstat_flags = 0xFFFF;
#endif
  if (dir) while ((de = readdir(dir)))
  {
#if 0
    char name[MAXPATH];
    strcpy(name,path);
    strcat(name,"/");
    strcat(name,de->d_name);
    struct stat st;
    stat(name,&st);
    if (!(st.st_mode & S_IFDIR) && fnmatch(slash,de->d_name,0)) continue;
    if (strcmp(de->d_name,".") == 0) continue;
    p = new DirSearchRec;
    strcpy(p->name,de->d_name);
    if (st.st_mode & S_IFDIR) strcat(p->name,"/");
    p->attr = st.st_mode;
    p->size = st.st_size;
    p->time = st.st_atime;
    fileList->insert(p);
#else
    struct ffblk &ff = dir->ff;
    if (!(ff.ff_attrib & FA_DIREC) && fnmatch(slash,de->d_name,0)) continue;
    if (strcmp(de->d_name,".") == 0) continue;
    p = new DirSearchRec;
    strcpy(p->name,de->d_name);
//    if (ff.ff_attrib & FA_DIREC) strcat(p->name,"/");
    p->attr = ff.ff_attrib;
    p->size = ff.ff_fsize;
    p->time = ((unsigned long)(ff.ff_fdate)) << 16 | (unsigned short)ff.ff_ftime;
    p->time = _file_time_stamp(p->time);
    fileList->insert(p);
#endif
  }
  if (dir) closedir(dir);
#if 0
  _djstat_flags = __djstat_flags;
#endif
  newList(fileList);
  if (list()->getCount() > 0)
    message( owner, evBroadcast, cmFileFocused, list()->at(0) );
  else
  {
    static DirSearchRec noFile;
    message( owner, evBroadcast, cmFileFocused, &noFile );
  }
}

void fexpand( char *rpath )
{
  char path[MAXLFNPATH];
  _fixpath(rpath,path);
  strcpy(rpath,path);
}

TStreamable *TFileList::build()
{
    return new TFileList( streamableInit );
}
