#define Uses_TScreen
#define Uses_TEvent
#define Uses_TFrame
#include <tv.h>

#include <dos.h>
#include <go32.h>
#if defined( DJGPP ) && ( DJGPP > 1 )
#include <dpmi.h>
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)
#else
#define REGS union REGS
#define INTR(nr,r) int86(nr,&r,&r)
#endif

#include <conio.h>
#include <sys/farptr.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

static ushort Equipment;
static uchar CrtInfo;
static uchar CrtRows;

ushort * TDisplay::equipment = &Equipment;
uchar * TDisplay::crtInfo = &CrtInfo;
uchar * TDisplay::crtRows = &CrtRows;

REGS r_display;

#define r (r_display)
#define AL (r.h.al)
#define BL (r.h.bl)
#define DL (r.h.dl)
#define AH (r.h.ah)
#define BH (r.h.bh)
#define DH (r.h.dh)
#define AX (r.x.ax)
#define BX (r.x.bx)
#define CX (r.x.cx)
#define DX (r.x.dx)

void TDisplay::SetPage(uchar page)
{
  Page = page;
  AH = 0x05;
  AL = page;
  videoInt();
}

void TDisplay::SetCursor(int x,int y)
{
  DH = y;
  DL = x;
  BH = GetPage();
  AH = 2;
  videoInt();
}

void TDisplay::GetCursor(int &x,int &y)
{
  AH = 3;
  BH = GetPage();
  videoInt();
  y = DH;
  x = DL;
}

ushort TDisplay::getCursorType()
{
  AH = 3;
  BH = GetPage();
  videoInt();
  return CX;
}

void TDisplay::setCursorType( ushort ct )
{
  AH = 1;
  CX = ct;
  BH = GetPage();
  videoInt();
}

void TDisplay::clearScreen( uchar , uchar )
{
  ScreenClear();
}

void TDisplay::videoInt()
{
    INTR(0x10,r_display);
}

ushort TDisplay::getRows()
{
  return ScreenRows();
}

ushort TDisplay::getCols()
{
  return ScreenCols();
}

ushort TDisplay::getCrtMode()
{
  ushort mode = ScreenMode();
  if (mode == smCO80) switch (getRows())
  {
    case 50: mode += 0x100;
    case 43: mode += 0x100;
    case 40: mode += 0x100;
    case 35: mode += 0x100;
    case 28: mode += 0x100;
      break;
    case 34:
      mode += 0x100; 
    case 30:
      mode += 0x700;
      switch (getCols())
      {
        case 94: mode += 0x200;
        case 90: mode += 0x200;
          break;
      }
      break;
  }
  return mode;
}

extern int emulate_mouse;
extern "C" int set_tweaked_text(int tmode); /* tmode from 0 to 5 */

static
void Textmode(int mode)
{
  __dpmi_regs r;
  r.h.ah = 0;
  r.h.al = (mode & 0xff) | 0x80; // do not clear the screen
  __dpmi_int(0x10,&r);
}

/* The following code is taken from conio.c. I had to do this,
   because I don't want to to set the video mode (crt mode) with
   clearing the screen, but the _set_scanline function does this.

   And I assume here anywhere, that there is an VGA adapter and no
   EGA!!!
*/

static int adapter_type = 2;

/* Set screen scan lines and load appropriate font.
   SCAN_LINES and FONT are as required by Int 10h functions 12h and 11h */
static void
set_scan_lines_and_font(int scan_lines, int font)
{
  __dpmi_regs regs;

  /* Set 200/350/400 scan lines.  */
  regs.h.ah = 0x12;
  regs.h.al = scan_lines;       /* 0: 200, 1: 350, 2: 400 */
  regs.h.bl = 0x30;
  __dpmi_int(0x10, &regs);

  /* Scan lines setting only takes effect when video mode is set.  */
  regs.x.ax = 0x83;
  __dpmi_int(0x10, &regs);

  /* Load a ROM BIOS font (0x11: 8x14, 0x12: 8x8, 0x14: 8x16).  */
  regs.h.bl = 0;                /* block zero */
  regs.h.ah = 0x11;
  regs.h.al = font & 0xff;
  __dpmi_int(0x10, &regs);
}

static int font_seg = -1;           /* segment of DOS buffer for 8x10 font */

/* Stretch a 8x8 font to the 8x10 character box.  This is required to
   use 80x40 mode on a VGA or 80x35 mode on an EGA, because the character
   box is 10 lines high, and the ROM BIOS doesn't have an appropriate font.
   So we create one from the 8x8 font by adding an extra blank line
   from each side.  */
static void
maybe_create_8x10_font(void)
{
  unsigned char *p;
  unsigned long src, dest, i, j;

  if (font_seg == -1)
    {
      __dpmi_regs regs;
      int buf_pm_sel;
      
      /* Allocate buffer in conventional memory. */
      font_seg = __dpmi_allocate_dos_memory(160, &buf_pm_sel);

      if (font_seg == -1)
        return;

      /* Get the pointer to the 8x8 font table.  */
      p = (unsigned char *)malloc(2560); /* 256 chars X 8x10 pixels */
      if (p == (unsigned char *)0)
        {
          errno = ENOMEM;
          __dpmi_free_dos_memory(buf_pm_sel);
          font_seg = -1;
          return;
        }
      regs.h.bh = 3;
      regs.x.ax = 0x1130;
      __dpmi_int(0x10, &regs);
      src =  ( ( (unsigned)regs.x.es ) << 4 ) + regs.x.bp;
      dest = ( (unsigned)font_seg ) << 4;

      /* Now copy the font to our table, stretching it to 8x10. */
      _farsetsel(_dos_ds);
      for (i = 0; i < 256; i++)
        {
          /* Fill first extra scan line with zeroes. */
          _farnspokeb(dest++, 0);

          for (j = 0; j < 8; j++)
            {
              unsigned char val = _farnspeekb(src++);

              _farnspokeb(dest++, val);
            }

          /* Fill last extra scan line with zeroes. */
          _farnspokeb(dest++, 0);
        }
    }
}

/* Load the 8x10 font we created into character generator RAM.  */
static void
load_8x10_font(void)
{
  __dpmi_regs regs;

  maybe_create_8x10_font();         /* create if needed */
  if (font_seg == -1)
    return;
  regs.x.es = font_seg;             /* pass pointer to our font in ES:BP */
  regs.x.bp = 0;
  regs.x.dx = 0;                    /* 1st char: ASCII 0 */
  regs.x.cx = 256;                  /* 256 chars */
  regs.h.bh = 10;                   /* 10 points per char */
  regs.h.bl = 0;                    /* block 0 */
  regs.x.ax = 0x1110;
  __dpmi_int(0x10, &regs);
}

/* Set screen scan lines and load 8x10 font.
   SCAN_LINES is as required by Int 10h function 12h. */
static void
set_scan_lines_and_8x10_font(int scan_lines)
{
  __dpmi_regs regs;

  regs.h.bl = 0x30;
  regs.h.ah = 0x12;
  regs.h.al = scan_lines;           /* 0: 200, 1: 350, 2: 400 */
  __dpmi_int(0x10, &regs);

  /* Set video mode, so that scan lines we set will take effect.  */
  regs.x.ax = 0x83;
  __dpmi_int(0x10, &regs);

  /* Load our 8x10 font and enable intensity bit.  */
  load_8x10_font();
}

/* Switch to screen lines given by NLINES.  */
void
__set_screen_lines(int nlines)
{
  switch (nlines)
    {
      __dpmi_regs regs;

      case 25:
          if (adapter_type)
            {
              /* Set 350 scan lines for EGA, 400 for VGA.  */
              regs.h.bl = 0x30;
              regs.h.ah = 0x12;
              regs.h.al = (adapter_type > 1 ? 2 : 1);
              __dpmi_int(0x10, &regs);

              /* Load ROM BIOS font: 8x14 for EGA, 8x16 for VGA.  */
              regs.h.bl = 0;
              regs.h.ah = 0x11;
              regs.h.al = (adapter_type > 1 ? 0x14 : 0x11);
              __dpmi_int(0x10, &regs);
            }

          /* Set video mode.  */
          regs.x.ax = 0x83;
          __dpmi_int(0x10, &regs);
          break;
      case 28:      /* VGA only */
          if (adapter_type > 1)
            set_scan_lines_and_font(2, 0x11);
          break;
      case 35:      /* EGA or VGA */
          if (adapter_type)
            set_scan_lines_and_8x10_font(1);
          break;
      case 40:      /* VGA only */
          if (adapter_type > 1)
            set_scan_lines_and_8x10_font(2);
          break;
      case 43:      /* EGA or VGA */
          if (adapter_type)
            set_scan_lines_and_font(1, 0x12);
          break;
      case 50:      /* VGA only */
          if (adapter_type > 1)
            set_scan_lines_and_font(2, 0x12);
          break;
    }

}

/* end of code from conio.c */

void TDisplay::setCrtMode( ushort mode )
{
  if (TMouse::present())
    TMouse::hide();
  if ((mode & 0xFF) == smCO80)
  {
    int hmode = mode >> 8;
    if (hmode > 6 && hmode < 13)
    {
      set_tweaked_text(hmode-7);
      emulate_mouse = 1;
    }
    else
    {
#if 0
      Textmode(C80);
#endif
      switch (hmode)
      {
        case 0:
          __set_screen_lines(25);
          break;
        case 1:
          __set_screen_lines(28);
          break;
        case 2:
          __set_screen_lines(35);
          break;
        case 3:
          __set_screen_lines(40);
          break;
        case 4:
          __set_screen_lines(43);
          break;
        case 5:
          __set_screen_lines(50);
          break;
      }
      emulate_mouse = 0;
    }
  }
  else
  {
    Textmode(mode);
    _farpokeb(_dos_ds,ScreenPrimary,'!');
    AX = 0x200;
    BH = 0;
    DX = 0;
    videoInt();
    AH = 0x0A;
    AL = ' ';
    BH = 0;
    CX = 1;
    videoInt();
    if (_farpeekb(_dos_ds,ScreenPrimary) != ' ')
    {
      Textmode(C80);
      emulate_mouse = 0;
    }
    else
    {
      emulate_mouse = 1;
    }
  }
  if (TMouse::present())
  {
    TMouse::setRange(getCols()-1,getRows()-1);
    TMouse::show();
  }
}

static unsigned getCodePage()
{
    //  get version number, in the form of a normal number
    AX = 0x3000;
    INTR(0x21,r);
    unsigned ver = (AH) | ((AL && 0xff) << 8);
    if( ver < 0x30C )
        return 437; // United States code page, for all versions before 3.3

    AX = 0x6601;
    INTR(0x21,r);
    return BX;
}

void TDisplay::updateIntlChars()
{
    if(getCodePage() != 437 )
        TFrame::frameChars[30] = '';
}
