#if defined( Uses_TParamList ) && !defined( __TParamList__ )
#define __TParamList__

class TParamList : public TCollection
{
public:
  TParamList(void) : TCollection(10,1) {}
  TParamList(const char *);
  Boolean FromString(const char *);
  void ToString(char * &);
private:
  virtual const char *streamableName() const
     { return name; }
  virtual void *readItem( ipstream& );
  virtual void writeItem( void *, opstream& );
protected:
  TParamList( StreamableInit ) : TCollection(streamableInit) {}
public:
  static const char * const near name;
  static TStreamable *build();
  TParamList & operator = (const TParamList &);
};

inline ipstream& operator >> ( ipstream& is, TParamList& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TParamList*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TParamList& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TParamList* cl )
    { return os << (TStreamable *)cl; }

#endif
