/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#include <rhide.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

/* This function is needed by the editor */

static char buffer[512];

/*
   This function checks at first, if the file is in the current
   directory. Then it searches in $(DJDIR)/data and if not exist,
   it returns the file name as it would exist in the directory,
   where this program is located without checking if it exists.
   This is a little different to that, what SET means with the
   function name, but I prefer not to store configuration
   files in the bin directory.
*/

char *ExpandFileNameToThePointWhereTheProgramWasLoaded(char *s)
{
  if (__file_exists(s))
  {
    strcpy(buffer,s);
    return buffer;
  }
  char *dj = getenv("DJDIR");
  if (dj)
  {
    strcpy(buffer,dj);
    strcat(buffer,"/data/");
    strcat(buffer,s);
    if (__file_exists(buffer)) return buffer;
  }
  strcpy(buffer,RHIDE_DIR);
  strcat(buffer,s);
  return buffer;
}


