/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#include <io.h>
#include <libide.h>
#include <rhide.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys\stat.h>
#include <fcntl.h>

#define STDOUT 1
#define STDERR 2

int oldstderr,oldstdout;
char *cpp_errname;
char *cpp_outname;
static char *errname = NULL;
static char *outname = NULL;
static int h_out,h_outbak;
static int h_err,h_errbak;

char *open_stderr(void)
{
  if (errname) free(errname);
  errname = strdup(tmpnam(NULL));
  if (debug_tempfiles)
  {
    fprintf(stderr,_("redirecting %s to %s\n"),"stderr",errname);
  }
#if 0
  int nul;
  fflush(stderr);
  nul = creat(errname, S_IREAD | S_IWRITE);
  oldstderr = dup(STDERR);
  dup2(nul, STDERR);
  close(nul);
#else
  h_err = open (errname,O_WRONLY | O_BINARY | O_CREAT | O_TRUNC,
                        S_IREAD | S_IWRITE);
  h_errbak = dup (2);
  fflush(stderr);  /* so any buffered chars will be written out */
  dup2 (h_err, 2);
#endif
  return errname;
}

void close_stderr(void)
{
#if 0
  dup2(oldstderr, STDERR);
  close(oldstderr);
#else
  dup2 (h_errbak, 2);
  close (h_err);
  close (h_errbak);
#endif
}

char *open_stdout(void)
{
  if (outname) free(outname);
  outname = strdup(tmpnam(NULL));
  if (debug_tempfiles)
  {
    fprintf(stderr,_("redirecting %s to %s\n"),"stdout",outname);
  }
#if 0
  int nul;
  fflush(stdout);
  nul = creat(outname, S_IREAD | S_IWRITE);
  oldstdout = dup(STDOUT);
  dup2(nul, STDOUT);
  close(nul);
#else
  h_out = open (outname,O_WRONLY | O_BINARY | O_CREAT | O_TRUNC,
                        S_IREAD | S_IWRITE);
  h_outbak = dup (1);
  fflush(stdout);  /* so any buffered chars will be written out */
  dup2 (h_out, 1);
#endif
  return outname;
}

void close_stdout(void)
{
#if 0
  dup2(oldstdout, STDOUT);
  close(oldstdout);
#else
  dup2 (h_outbak, 1);
  close (h_out);
  close (h_outbak);
#endif
}
