/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Uses_TProject
#define Uses_TOptions
#define Uses_TDependency
#define Uses_TDepCollection
#include <libide.h>
#define Uses_tvutilFunctions
#include <libtvuti.h>
#include <rhide.h>

#include <stdio.h>
#include <stdlib.h>
#include <locale.h>
#include <string.h>
#include <process.h>

extern int recursive_make;
Boolean ReadProject(const char *);

Boolean PushProject(char *,char *)
{
  return False;
}

void PopProject()
{
}

int main(int argc,char *argv[])
{
  char *outname = NULL;
  char *pname = NULL;
  int i,all_deps=0;
  char *locale_dir = getenv("LOCALEDIR");
  if (!locale_dir)
  {
    locale_dir = getenv("DJDIR");
    if (locale_dir)
    {
      static char tmp[512];
      strcpy(tmp,locale_dir);
      strcat(tmp,"/data/locale");
      locale_dir = tmp;
    }
  }
  setlocale(LC_ALL,"");
  BINDTEXTDOMAIN("rhide",locale_dir);
  TEXTDOMAIN("rhide");
  recursive_make = 0;
  for (i=1;i<argc;i++)
  {
    if (strcmp(argv[i],"-r") == 0)
    {
      recursive_make = 1;
    }
    if (strcmp(argv[i],"-r-") == 0)
    {
      recursive_make = 0;
    }
    else if (strcmp(argv[i],"-d") == 0)
    {
      all_deps=1;
    }
    else if (strcmp(argv[i],"-d-") == 0)
    {
      all_deps=0;
    }
    else if (strcmp(argv[i],"-o") == 0)
    {
      i++;
      if (i>=argc)
      {
        fprintf(stderr,_("-o needs an argument\n"));
        return -1;
      }
      outname = argv[i];
    }
    else if (argv[i][0] != '-')
    {
      pname = argv[i];
      break;
    }
  }
  if (!pname)
  {
    fprintf(stderr,_("a projectfile must be given\n"));
    return -2;
  }
  string_dup(project_name,pname);
  if (ReadProject(project_name) == False)
  {
    fprintf(stderr,_("error reading projectfile %s\n"),project_name);
    return -3;
  }
  AllDeps = all_deps;
  WriteMake(outname,argc,argv);
  if (recursive_make && Project.dependencies)
  {
    for (i=0;i<Project.dependencies->getCount();i++)
    {
      TDependency *_dep = (TDependency *)Project.dependencies->at(i);
      if (_dep->compile_id == COMPILE_PROJECT)
      {
        char *dir,*name,*ext,*pname,*makname,*recur,*all;
        split_fname(_dep->dest_name,dir,name,ext);
        string_dup(pname,dir);
        string_cat(pname,name);
        string_cat(pname,PROJECT_EXT);
        string_dup(makname,"-o ");
        string_cat(makname,dir);
        string_cat(makname,name);
        string_cat(makname,".mak");
        if (recursive_make) string_dup(recur,"-r");
        else string_dup(recur,"-r-");
        if (all_deps) string_dup(all,"-d");
        else string_dup(all,"-d-");
        fprintf(stderr,"%s %s %s %s %s\n",argv[0],makname,pname,recur,all);
        spawnl(P_WAIT,argv[0],argv[0],makname,pname,recur,all,NULL);
        string_free(dir);
        string_free(name);
        string_free(ext);
        string_free(pname);
        string_free(makname);
        string_free(recur);
        string_free(all);
      }
    }
  }
  return 0;
}

char *WUC()
{
  return NULL;
}

