#if ( __GNUC_MINOR__ < 7 )
#pragma interface
#endif

#include <dir.h>
#include <string.h>
#include <limits.h>

#ifndef __CEDITOR_H_
#define __CEDITOR_H_

#ifdef __GNUC__
#define uint16                  unsigned short
#define uint32                  unsigned int
#define UnUsed                  __attribute__ ((unused))
#else
#define uint16                  unsigned
#define uint32                  unsigned
#define UnUsed
#endif

// Maximun line length supported
const
  DeltaLineLen = 200,    // Increment when the actual limit is reached
#ifdef __GNUC__
  MaxLineLen   = 30000,  // Maximun maximorum
#else
  MaxLineLen   = 300,
#endif
  MinLineLen   = 80;     // Minimun

#endif // __CEDITOR_H_

#if !defined( __EDIT_COMMAND_CODES )
#define __EDIT_COMMAND_CODES

const
  ufUpdate = 0x01,
  ufLine   = 0x02,
  ufView   = 0x04;

const
  smExtend = 0x01,
  smDouble = 0x02;

const uint32
  sfSearchFailed = UINT_MAX;


const
  cmSave        = 80,
  cmSaveAs      = 81,
  cmFind        = 82,
  cmReplace     = 83,
  cmSearchAgain = 84;

#if defined( RHIDE ) // RHIDE does no longer use editors.h
const
  cmUpdateTitle = 523;
#endif

const
  edOutOfMemory   = 0,
  edReadError     = 1,
  edWriteError    = 2,
  edCreateError   = 3,
  edSaveModify    = 4,
  edSaveUntitled  = 5,
  edSaveAs        = 6,
  edFind          = 7,
  edSearchFailed  = 8,
  edReplace       = 9,
  edReplacePrompt = 10;

const
  efCaseSensitive   = 0x0001,
  efWholeWordsOnly  = 0x0002,
  efPromptOnReplace = 0x0004,
  efReplaceAll      = 0x0008,
  efDoReplace       = 0x0010,
  efBackupFiles     = 0x0100;

#endif  // __EDIT_COMMAND_CODES


#if !defined( __CEDIT_COMMAND_CODES )
#define __CEDIT_COMMAND_CODES

#define ComInside          1  // C++ comment in this line
#define InsideCom          2  // All commented
#define Prepro             4  // Starts with #
#define ExtPrepro          8  // Prepro+ends with \ <= fuck you GCC, bug!!
#define StartCom          16  // /*
#define EndCom            32  // */
#define ExtCom            64  // more /* than */
#define StartInCom       128  // The first char is commented
#define InsideCom2       256  // All commented with { }
#define StartCom2        512  // {
#define EndCom2         1024  // }
#define ExtCom2         2048  // more { than }
#define StartInCom2     4096  // The first char is commented
#define ExtString       8192  // a String ends with a \ and is continued on the next line
#define StartString    16384  // the line starts within a string (see ExtString)

#define Not_ComInside      (~ComInside)
#define Not_InsideCom      (~InsideCom)
#define Not_Prepro         (~Prepro)
#define Not_ExtPrepro      (~ExtPrepro)
#define Not_StartCom       (~StartCom)
#define Not_EndCom         (~EndCom)
#define Not_ExtCom         (~ExtCom)
#define Not_StartInCom     (~StartInCom)
#define Not_InsideCom2     (~InsideCom2)
#define Not_StartCom2      (~StartCom2)
#define Not_EndCom2        (~EndCom2)
#define Not_ExtCom2        (~ExtCom2)
#define Not_StartInCom2    (~StartInCom2)
#define Not_ExtString      (~ExtString)
#define Not_StartString    (~StartString)
#define FilterHere         (Not_ComInside & Not_StartCom & Not_EndCom & \
                            Not_ExtPrepro & Not_StartCom2 & Not_EndCom2 & \
                            Not_ExtString & Not_StartString)
#define FilterProp         (ExtCom | ExtPrepro | ExtCom2 | ExtString)
#define PartialCom         (StartCom | ComInside | EndCom | StartCom2 | EndCom2)
#define InsidePascalCom    (InsideCom | InsideCom2)
#define StartInPascalCom   (StartInCom | StartInCom2)

const
  smEndSel = 0x04,
  smStartSel=0x08;

const
  ufStatus = 0x08,
  ufFound  = 0x10,
  ufHLChar = 0x20;

const
  /* Attention!!!! the fucking TVision doesn't support the enable/disable
     commands feactures for commands above 255, so the base must be under
     255-total_commands, the available values are from 100 to 255.
     The example used uses 100-105 for file open, etc. */
#if defined( RHIDE )
/* Robert's TV library supports enable/disable commands for commands up to
   1023. A safe value for RHIDE is from 600. */
  cmbBaseNumber        = 600,
#else
  cmbBaseNumber        = 110,
#endif
  cmbCtrlK             = 254,
  cmbCtrlQ             = 255,
  cmbToLower           =   1,
  cmbSelLength         =   2,
  cmbFirstLineInScreen =   3,
  cmbLastLineInScreen  =   4,
  cmbIndentBlkOne      =   5,
  cmbUnIndentBlkOne    =   6,
  cmbIndentBlk         =   7,
  cmbUnIndentBlk       =   8,
  cmbSearchStart       =   9,
  cmbSearchEnd         =  10,
  cmbExpandCode        =  11,
  cmbDelPrevWord       =  12,
  cmbEndSelect         =  13,
  cmbSmartUnIndent     =  14,
  cmbSmartIndent       =  15,
  cmbReplaceSelect     =  16,
  cmbGotoEditorLine    =  17,
  cmbGoBeginBlock      =  18,
  cmbGoEndBlock        =  19,
  cmbMarkLine          =  20,
  cmbMarkWord          =  21,
  cmbMoveBlock         =  22,
  cmbScrollDown        =  23,
  cmbScrollUp          =  24,
  cmbPutMark0          =  25,
  cmbPutMark1          =  26,
  cmbPutMark2          =  27,
  cmbPutMark3          =  28,
  cmbPutMark4          =  29,
  cmbPutMark5          =  30,
  cmbPutMark6          =  31,
  cmbPutMark7          =  32,
  cmbPutMark8          =  33,
  cmbPutMark9          =  34,
  cmbGotoMark0         =  35,
  cmbGotoMark1         =  36,
  cmbGotoMark2         =  37,
  cmbGotoMark3         =  38,
  cmbGotoMark4         =  39,
  cmbGotoMark5         =  40,
  cmbGotoMark6         =  41,
  cmbGotoMark7         =  42,
  cmbGotoMark8         =  43,
  cmbGotoMark9         =  44,
  cmbInsertText        =  45,
  cmbReadBlock         =  46,
  cmbWriteBlock        =  47,
  cmbNewLine           =  48,
  cmbBackSpace         =  49,
  cmbCharLeft          =  50,
  cmbCharRight         =  51,
  cmbWordLeft          =  52,
  cmbWordRight         =  53,
  cmbLineStart         =  54,
  cmbLineEnd           =  55,
  cmbLineUp            =  56,
  cmbLineDown          =  57,
  cmbPageUp            =  58,
  cmbPageDown          =  59,
  cmbTextStart         =  60,
  cmbTextEnd           =  61,
  cmbDelChar           =  62,
  cmbDelWord           =  63,
  cmbDelStart          =  64,
  cmbDelEnd            =  65,
  cmbDelLine           =  66,
  cmbInsMode           =  67,
  cmbStartSelect       =  68,
  cmbHideSelect        =  69,
  cmbIndentMode        =  70,
  cmbUpdateTitle       =  71,
  cmbCut               =  72,
  cmbCopy              =  73,
  cmbPaste             =  74,
  cmbUndo              =  75,
  cmbSearchAgain       =  76,
  cmbClear             =  77,
  cmbReplace           =  78,
  cmbFind              =  79,
  cmbSearchOpPar       =  80,
  cmbSearchClPar       =  81,
  cmbSearchOpCor       =  82,
  cmbSearchClCor       =  83,
  cmbToUpper           =  84,
  cmbRedo              =  85,
  cmbSetLocalOptions   =  86,
  cmbExpandAllTabs     =  87,
  cmbCompactBuffer     =  88,
  cmbRecordMacro       =  89,
  cmbStopMacro         =  90,
  cmbPlayMacro         =  91,
  cmbSetGlobalOptions  =  92,
  cmbSaveAsUNIX        =  93,
  cmbCopyBlock         =  94,
  cmbSelRectStart      =  95,
  cmbSelRectEnd        =  96,
  cmbSelRectCopy       =  97,
  cmbSelRectPaste      =  98,
  cmbSelRectDel        =  99,
  cmbSelRectCut        = 100,
  cmbSelRectMove       = 101,
  cmbSelRectHide       = 102,
  cmbLastPosCur        = 103,
  cmbToggleMoveOnPaste = 104,
  cmbJumpToFunction    = 105,
  cmbProfileEditor     = 106,
  cmbColorsChanged     = 107;

const
  cmcToUpper           = cmbToUpper+cmbBaseNumber,
  cmcToLower           = cmbToLower+cmbBaseNumber,
  cmcSelLength         = cmbSelLength+cmbBaseNumber,
  cmcFirstLineInScreen = cmbFirstLineInScreen+cmbBaseNumber,
  cmcLastLineInScreen  = cmbLastLineInScreen+cmbBaseNumber,
  cmcIndentBlkOne      = cmbIndentBlkOne+cmbBaseNumber,
  cmcUnIndentBlkOne    = cmbUnIndentBlkOne+cmbBaseNumber,
  cmcIndentBlk         = cmbIndentBlk+cmbBaseNumber,
  cmcUnIndentBlk       = cmbUnIndentBlk+cmbBaseNumber,
  cmcSearchStart       = cmbSearchStart+cmbBaseNumber,
  cmcSearchEnd         = cmbSearchEnd+cmbBaseNumber,
  cmcExpandCode        = cmbExpandCode+cmbBaseNumber,
  cmcDelPrevWord       = cmbDelPrevWord+cmbBaseNumber,
  cmcEndSelect         = cmbEndSelect+cmbBaseNumber,
  cmcSmartUnIndent     = cmbSmartUnIndent+cmbBaseNumber,
  cmcSmartIndent       = cmbSmartIndent+cmbBaseNumber,
  cmcReplaceSelect     = cmbReplaceSelect+cmbBaseNumber,
  cmcGotoEditorLine    = cmbGotoEditorLine+cmbBaseNumber,
  cmcGoBeginBlock      = cmbGoBeginBlock+cmbBaseNumber,
  cmcGoEndBlock        = cmbGoEndBlock+cmbBaseNumber,
  cmcMarkLine          = cmbMarkLine+cmbBaseNumber,
  cmcMarkWord          = cmbMarkWord+cmbBaseNumber,
  cmcMoveBlock         = cmbMoveBlock+cmbBaseNumber,
  cmcScrollDown        = cmbScrollDown+cmbBaseNumber,
  cmcScrollUp          = cmbScrollUp+cmbBaseNumber,
  cmcPutMark0          = cmbPutMark0+cmbBaseNumber,
  cmcPutMark1          = cmbPutMark1+cmbBaseNumber,
  cmcPutMark2          = cmbPutMark2+cmbBaseNumber,
  cmcPutMark3          = cmbPutMark3+cmbBaseNumber,
  cmcPutMark4          = cmbPutMark4+cmbBaseNumber,
  cmcPutMark5          = cmbPutMark5+cmbBaseNumber,
  cmcPutMark6          = cmbPutMark6+cmbBaseNumber,
  cmcPutMark7          = cmbPutMark7+cmbBaseNumber,
  cmcPutMark8          = cmbPutMark8+cmbBaseNumber,
  cmcPutMark9          = cmbPutMark9+cmbBaseNumber,
  cmcGotoMark0         = cmbGotoMark0+cmbBaseNumber,
  cmcGotoMark1         = cmbGotoMark1+cmbBaseNumber,
  cmcGotoMark2         = cmbGotoMark2+cmbBaseNumber,
  cmcGotoMark3         = cmbGotoMark3+cmbBaseNumber,
  cmcGotoMark4         = cmbGotoMark4+cmbBaseNumber,
  cmcGotoMark5         = cmbGotoMark5+cmbBaseNumber,
  cmcGotoMark6         = cmbGotoMark6+cmbBaseNumber,
  cmcGotoMark7         = cmbGotoMark7+cmbBaseNumber,
  cmcGotoMark8         = cmbGotoMark8+cmbBaseNumber,
  cmcGotoMark9         = cmbGotoMark9+cmbBaseNumber,
  cmcInsertText        = cmbInsertText+cmbBaseNumber,
  cmcReadBlock         = cmbReadBlock+cmbBaseNumber,
  cmcWriteBlock        = cmbWriteBlock+cmbBaseNumber,
  cmcNewLine           = cmbNewLine+cmbBaseNumber,
  cmcBackSpace         = cmbBackSpace+cmbBaseNumber,
  cmcCharLeft          = cmbCharLeft+cmbBaseNumber,
  cmcCharRight         = cmbCharRight+cmbBaseNumber,
  cmcWordLeft          = cmbWordLeft+cmbBaseNumber,
  cmcWordRight         = cmbWordRight+cmbBaseNumber,
  cmcLineStart         = cmbLineStart+cmbBaseNumber,
  cmcLineEnd           = cmbLineEnd+cmbBaseNumber,
  cmcLineUp            = cmbLineUp+cmbBaseNumber,
  cmcLineDown          = cmbLineDown+cmbBaseNumber,
  cmcPageUp            = cmbPageUp+cmbBaseNumber,
  cmcPageDown          = cmbPageDown+cmbBaseNumber,
  cmcTextStart         = cmbTextStart+cmbBaseNumber,
  cmcTextEnd           = cmbTextEnd+cmbBaseNumber,
  cmcDelChar           = cmbDelChar+cmbBaseNumber,
  cmcDelWord           = cmbDelWord+cmbBaseNumber,
  cmcDelStart          = cmbDelStart+cmbBaseNumber,
  cmcDelEnd            = cmbDelEnd+cmbBaseNumber,
  cmcDelLine           = cmbDelLine+cmbBaseNumber,
  cmcInsMode           = cmbInsMode+cmbBaseNumber,
  cmcStartSelect       = cmbStartSelect+cmbBaseNumber,
  cmcHideSelect        = cmbHideSelect+cmbBaseNumber,
  cmcIndentMode        = cmbIndentMode+cmbBaseNumber,
  cmcUpdateTitle       = cmbUpdateTitle+cmbBaseNumber,
  cmcCut               = cmbCut+cmbBaseNumber,
  cmcCopy              = cmbCopy+cmbBaseNumber,
  cmcPaste             = cmbPaste+cmbBaseNumber,
  cmcUndo              = cmbUndo+cmbBaseNumber,
  cmcSearchAgain       = cmbSearchAgain+cmbBaseNumber,
  cmcClear             = cmbClear+cmbBaseNumber,
  cmcReplace           = cmbReplace+cmbBaseNumber,
  cmcFind              = cmbFind+cmbBaseNumber,
  cmcSearchOpPar       = cmbSearchOpPar+cmbBaseNumber,
  cmcSearchClPar       = cmbSearchClPar+cmbBaseNumber,
  cmcSearchOpCor       = cmbSearchOpCor+cmbBaseNumber,
  cmcSearchClCor       = cmbSearchClCor+cmbBaseNumber,
  cmcRedo              = cmbRedo+cmbBaseNumber,
  cmcSetLocalOptions   = cmbSetLocalOptions+cmbBaseNumber,
  cmcExpandAllTabs     = cmbExpandAllTabs+cmbBaseNumber,
  cmcCompactBuffer     = cmbCompactBuffer+cmbBaseNumber,
  cmcRecordMacro       = cmbRecordMacro+cmbBaseNumber,
  cmcStopMacro         = cmbStopMacro+cmbBaseNumber,
  cmcPlayMacro         = cmbPlayMacro+cmbBaseNumber,
  cmcSetGlobalOptions  = cmbSetGlobalOptions+cmbBaseNumber,
  cmcSaveAsUNIX        = cmbSaveAsUNIX+cmbBaseNumber,
  cmcCopyBlock         = cmbCopyBlock+cmbBaseNumber,
  cmcSelRectStart      = cmbSelRectStart+cmbBaseNumber,
  cmcSelRectEnd        = cmbSelRectEnd+cmbBaseNumber,
  cmcSelRectCopy       = cmbSelRectCopy+cmbBaseNumber,
  cmcSelRectPaste      = cmbSelRectPaste+cmbBaseNumber,
  cmcSelRectDel        = cmbSelRectDel+cmbBaseNumber,
  cmcSelRectCut        = cmbSelRectCut+cmbBaseNumber,
  cmcSelRectMove       = cmbSelRectMove+cmbBaseNumber,
  cmcSelRectHide       = cmbSelRectHide+cmbBaseNumber,
  cmcLastPosCur        = cmbLastPosCur+cmbBaseNumber,
  cmcToggleMoveOnPaste = cmbToggleMoveOnPaste+cmbBaseNumber,
  cmcJumpToFunction    = cmbJumpToFunction+cmbBaseNumber,
  cmcProfileEditor     = cmbProfileEditor+cmbBaseNumber,
  cmcColorsChanged     = cmbColorsChanged+cmbBaseNumber;


const
  edLineLenght    = 11;


const
  edGotoLine        = 12,
  edSetLocalOptions = 13,
  edLineOverflow    = 14,
  edSetGlobalOptions= 15,
  edJumpToFunction  = 16;

// Maximun values allowed
const
  setMaxScreenX = 200,
  setMaxScreenY = 100;

const
  efInSelection     = 0x0020;

const splEndOfList  = -1000;

extern unsigned char kbFunNormal[128];
extern unsigned char kbFunShift[128];
extern unsigned char kbFunCtrl[128];
extern unsigned char kbFunShiftCtrl[128];
extern unsigned char kbFunCtrlQNorm[128];
extern unsigned char kbFunCtrlKNorm[128];
extern unsigned char kbFunCtrlKShift[128];

// Color codes defined by Robert
#define cNormal   1
#define cMarked   2
#define cComment  3
#define cReserved 4
#define cIdent    5
#define cSymbol   6
#define cString   7
#define cInteger  8
#define cFloat    9
#define cOctal    10
#define cHex      11
#define cChar     12
#define cPre      13
#define cIllegal  14
#define cUser     15
#define cCPU      16
#define cBreak    17
#define cSymbol2  18
#define cCrossCur 19
#define cStatusLi 20
#define cMPHighL  21
#define cRectSel  22

#define cNumColors 23

#endif  // __CEDIT_COMMAND_CODES


#if defined( Uses_TFindCDialogRec ) && !defined( __TFindCDialogRec )
#define __TFindCDialogRec

#if !defined( __STRING_H )
#include <String.h>
#endif  // __STRING_H

struct TFindCDialogRec
{
 TFindCDialogRec( const char *str, ushort flgs, ushort insel, ushort from_where )
   {
    strcpy( find, str );
    options = flgs;
    in_sel = insel;
    from = from_where;
   }
 char find[maxFindStrLen];
 ushort options;
 ushort in_sel;
 ushort from;
};

#endif  // Uses_TFindCDialogRec




#if defined( Uses_TReplaceCDialogRec ) && !defined( __TReplaceCDialogRec )
#define __TReplaceCDialogRec

#include <string.h>

struct TReplaceCDialogRec
{
 TReplaceCDialogRec( const char *str, const char *rep, ushort flgs,
                     ushort insel, ushort from_where )
    {
     strcpy( find, str );
     strcpy( replace, rep );
     options = flgs;
     in_sel = insel;
     from = from_where;
    }
 char find[maxFindStrLen];
 char replace[maxReplaceStrLen];
 ushort options;
 ushort in_sel;
 ushort from;
};

#endif  // Uses_TReplaceCDialogRec



#if (defined( Uses_LineLengthArray ) || defined( Uses_TCEditor)) && \
    !defined( __LineLengthArray )
#define __LineLengthArray

class LineLengthArray
{
 public:
 LineLengthArray();
 ~LineLengthArray();
 operator [](unsigned pos) { return elArray[pos]; };
 void set(unsigned pos, unsigned short val);
 void insert(unsigned pos, unsigned short val);
 void del(unsigned pos);
 void deleteRange(unsigned from,unsigned to);
 unsigned short getAttr(unsigned line) { return elArrayAttr[line]; };
 void setAttr(unsigned line, unsigned short val);
 void setAll(unsigned line, unsigned short length, unsigned short attr);
 unsigned Length;
 unsigned short *elArray;
 unsigned short *elArrayAttr;

 private:
 unsigned MaxPos;
};

#endif // Uses_LineLengthArray


#if defined( Uses_TCEditor ) && !defined( __TCEditor )
#define __TCEditor

#define Uses_TViewPlus
#include "viewplus.h"

typedef ushort (*TEditorDialog)( int, ... );
ushort defEditorDialog( int dialog, ... );

#ifdef USE_TSTRCOL
class TStrCol : public TStringCollection
{
 public:
 TStrCol(short aLimit, short aDelta) :  TStringCollection(aLimit,aDelta) {};
 int getCount(void) { return count; };
};

extern TStrCol *ReservedWords;
extern TStrCol *UserWords;
extern TStrCol *PascalRWords;
extern TStrCol *ClipperRWords;
#else
extern TStringCollection *ReservedWords;
extern TStringCollection *UserWords;
extern TStringCollection *PascalRWords;
extern TStringCollection *ClipperRWords;
#define TStrCol TStringCollection
#endif

Boolean LoadPseudoMacroFile(char *name);
Boolean CreateSHShortCutTables(void);
int InitTCEditor(char *s,Boolean force);

class far TRect;
class far TScrollBar;
class far TIndicator;
class far TEvent;

/********************************* UNDO types and constants *****************/
#define MAX_UNDO 32
#define UNDO_CHARS_SIZE 100

enum UndoState { undoNoUndo, undoInMov, undoPutChar, undoDelChar, undoInsert,
                 undoDelete, undoPreDelete, undoPreInsert, undoDestroyLine,
                 undoDelCharDel, undoCutInMov, undoIndBlockSp,undoIndBlockTab,
                 undoIndBlock, undoPre1IndBlock, undoPre2IndBlock, undoUnIndBlock,
                 undoToUpper, undoToLower, undoOvrPutChar, undoPreInsertSp,
                 undoRectPaste, undoRectDel, undoRectCopy, undoRectStart,
                 undoRectEnd, undoRectHide, undoDeleteBuf, undoPostCopyInfo,
                 undoPreCopyInfo };

enum UndoDestroy { destBack };

struct BufPlusLen
{
 unsigned len;
#ifdef __GNUC__
 char s[0];
#else
 char s[];
#endif
};

struct UndoCell
{
 int X,Y;
 int Xf,Yf;
 char *s;
 union
   {
    char *s;
    int  l;
    unsigned OffSet;
    BufPlusLen *BufL;
   } s2;
 UndoState Type;
 int Length;
 uint32 selStart,selEnd;
 uint32 selStartf,selEndf;
 char Flags;
 char Count;
};

struct stUndoInsert
{
 char *s;
 BufPlusLen *Eated;
 int   l;
};

const undoSelHided=1,
      undoModified=2,
      undoSelHidedF=4,
      undoModifiedF=8,
      undoOverWriteF=16,
      undoOverWrite=32;
/************************* End of UNDO types and constants *****************/

/* a Wish */
enum shlState { shlNoSyntax=0,shlCSyntax=1,shlPascalSyntax=2,
                shlClipperSyntax=3,shlGASSyntax=4 };

/************************* Rectangular Selection defs *****************/
// Notes:
// The Xr1 col is included, but not the Xr2, so the width is: Xr2-Xr1
// The Yr1 row is included AND the Yr2 row too, so the heigth is: Yr2-Yr1+1

struct selRecSt {
 int Xr1,Yr1;     // Top left corner of the original sel.
 int Xr2,Yr2;     // Botton right of the original sel.
 Boolean selHide; // Only used in the undo blocks
 int Ycur;        // Where the cursor is
#ifdef __GNUC__
 char s[0];
#else
 char s[];       // Here is where the data start
#endif
};

/************************* End of Rectangular Selection defs *****************/

struct GlobalOptionsRect {
        uint16 t1;
        char tab[3];
       };

class TCEditor : public TViewPlus
{

public:

    TCEditor( const TRect&, TScrollBar *, TScrollBar *, TIndicator *, unsigned );
    virtual ~TCEditor();

    virtual void shutDown();

    char bufChar( unsigned Pos ) { return buffer[Pos]; };
    unsigned bufPtr( unsigned Pos ) { return Pos; };
    virtual void changeBounds( const TRect& );
    virtual void convertEvent( TEvent& );
    Boolean cursorVisible();
    void deleteSelect();
    virtual void doneBuffer();
    virtual void draw();
    virtual TPalette& getPalette() const;
    virtual void handleEvent( TEvent& );
    virtual void initBuffer();
    Boolean insertBuffer( char *, unsigned, unsigned, Boolean, Boolean, Boolean moveToEnd=True );
    virtual Boolean insertFrom( TCEditor * );
    Boolean insertText( const void *, unsigned, Boolean );
    void scrollTo( int, int );
    Boolean search( const char *, unsigned );
    virtual Boolean setBufSize( unsigned );
    void setCmdState( uint16 command, Boolean enable );
    void setSelect( unsigned, unsigned, Boolean);
    virtual void setState( uint16 aState, Boolean enable );
    void trackCursor( Boolean );
    void undo();
    virtual void updateCommands();
    virtual Boolean valid( unsigned ) { return isValid; };

    int charPos( unsigned, unsigned );
    unsigned charPtr( unsigned, int );
    Boolean clipCopy();
    void clipCut();
    void clipPaste();
    void deleteRange( unsigned , unsigned, Boolean );
    void doUpdate();
    void doSearchReplace();
    void drawLines( int, int, unsigned );
    void find();
    //ushort getMousePtr( TPoint );
    Boolean hasSelection() { return Boolean(selStart<selEnd); };
    Boolean hasVisibleSelection() { return Boolean(!selHided && selStart<selEnd); };
//{ return Boolean(IslineInEdition ? selLineStart<selLineEnd : selStart<selEnd); };
    void hideSelect();
    Boolean isClipboard() { return Boolean(clipboard == this); };
    unsigned lineEnd( unsigned );
    //unsigned lineEndC( unsigned );
    //ushort lineMove( ushort, int );
    unsigned lineStart( unsigned );
    void lock() { lockCount++; };
    void newLine();
    unsigned nextChar( unsigned );
    unsigned nextLine( unsigned );
    unsigned nextWordC( unsigned );
    unsigned prevChar( unsigned );
    unsigned prevLine( unsigned );
    char *WordUnderCursor(unsigned maxLength=256);
    Boolean StringUnderCursor(uint32 &word_start, uint32 &word_end);
    void replace();
    void setBufLen( unsigned );
    void setCurPtr( unsigned, uchar );
    void startSelect();
    void toggleInsMode( Boolean allowUndo );
    void unlock();
    void update( uchar );
    void checkScrollBar( const TEvent&, TScrollBar *, int& );
    unsigned LenWithoutCRLF(unsigned yInFile,char *lineStart);
    void ExpandAllTabs(void);
    void CompactBuffer();
    uint16 CompactFlags(void);
    void ExpandFlags(uint16 t,Boolean allowUndo=True);
    Boolean selRectCopy(Boolean allowUndo=True);
    Boolean selRectPaste(struct selRecSt *st, int X, int Y, Boolean allowUndo=True);
    Boolean selRectDelete(int X1, int Y1, int X2, int Y2, Boolean allowUndo=True);
    void UndoRectangularPasteClear(UndoCell &un);
    Boolean FillUndoForRectangularPasteClear(int Height,struct UndoCell &un,UndoState st);
    Boolean FillUndoForRectangularStartEnd(UndoState st);
    static void SetGlobalOptions(void);
    static void ExpandGlobalOptions(GlobalOptionsRect *temp);
    static void CompactGlobalOptions(GlobalOptionsRect *temp);
    void ExpandGlobalOptionsLocally(GlobalOptionsRect *temp);
    void undoOneAction();

    TScrollBar *hScrollBar;
    TScrollBar *vScrollBar;
    TIndicator *indicator;
    char *buffer;
    unsigned bufSize;
    unsigned bufLen;
    unsigned gapLen;
    unsigned selStart;
    unsigned selEnd;
    unsigned curPtr;
    TPoint delta;
    TPoint limit;
    unsigned drawPtr;
    unsigned delCount;
    unsigned insCount;
    Boolean isValid;
    Boolean canUndo;
    Boolean modified;
    Boolean selecting;
    Boolean overwrite;

    Boolean autoIndent;               // Indent when ENTER is pressed
    static Boolean staticAutoIndent;  // the static version
    Boolean intelIndent;              // try to be smart in the autoindent
    static Boolean staticIntelIndent; // the static version
    unsigned tabSize;                 // The size of the tabulator
    static unsigned staticTabSize;    // the static version
    Boolean UseTabs;                  // True if when we press Tab an ascii 9 is inserted
    static Boolean staticUseTabs;     // the static version
    Boolean PersistentBlocks;         // True if the blocks isn't deleted after a move
    static Boolean staticPersistentBlocks;  // the static version
    Boolean ShowMatchPair;            // True if the editor highlights the match pair
    static Boolean staticShowMatchPair;     // the static version
    static Boolean staticNoMoveToEndPaste;  //  True if the cursor is moved to the end of
                                            // the pasted area.
    Boolean TransparentSel;           // True if you can see through the slelection
    static Boolean staticTransparentSel; // the static version
    Boolean OptimalFill;             // When True the editor tries to fill all the gaps
                                     // with tabs instead of spaces
    static Boolean staticOptimalFill;// the static version

    static TEditorDialog near editorDialog;
    static unsigned near editorFlags;
    static unsigned near fromFlags;
    static unsigned near whereFlags;
    static char near findStr[maxFindStrLen];
    static char near replaceStr[maxReplaceStrLen];
    static TCEditor * near clipboard;
    uchar lockCount;
    uchar updateFlags;
    int keyState;
    unsigned WantedCol;
    //void formatLine(void *, unsigned, int, unsigned short );
    void formatLine(void *, unsigned, int, unsigned short, unsigned, unsigned short, unsigned );
    void formatLineHighLight(void *, unsigned, int, unsigned short, unsigned, unsigned short, unsigned );
    void formatLineHighLightPascal(void *,unsigned,int,unsigned short,unsigned,unsigned short, unsigned );
    void formatLineHighLightClipper(void *,unsigned,int,unsigned short,unsigned,unsigned short, unsigned );
    void formatLineHighLightTransparent(void *, unsigned, int, unsigned short, unsigned, unsigned short, unsigned );
    void formatLineHighLightPascalTransparent(void *,unsigned,int,unsigned short,unsigned,unsigned short, unsigned );
    void formatLineHighLightClipperTransparent(void *,unsigned,int,unsigned short,unsigned,unsigned short, unsigned );
    unsigned lineMove( unsigned p, int count );
    void TurnOffHighLight(void) {  formatLinePtr=&TCEditor::formatLine; SyntaxHL=shlNoSyntax; };
    void TurnOnCHighLight(void);
    void TurnOnPascalHighLight(void);
    void TurnOnClipperHighLight(void);
    void SetHighlightTo(shlState sHL);
    void RecalculateLineAttributes(void);
    void ProfileEditor(void);
    void CacheColors(void);

    // New Stuff
    void InsertCharInLine(char cVal, Boolean allowUndo=True);
    void MakeEfectiveLineInEdition();
    char *ColToPointer();
    char *ColToPointer(int &Dif);
    char *ColToPointerPost();
    int  nextWord();
    int  prevWord(Boolean moveCursor=True);
    void MoveCursor(char *ori,char *dest);
    void EditLine();
    void deleteRange(char *from,char *to,Boolean allowUndo=True);
    void deleteRangeLineInEdition(char *from,char *to,int x);
    int  LineWidth();
    int  LineWidth(char *s, char *d);
    void insertSpaces( unsigned length, int X, Boolean canUseTabs=True );
    void MoveLinesUp(int i);
    void MoveLinesDown(int i);
    void SetStartOfSelecting(unsigned startOffSet);
    void UpdateSelecting(void);
    void MoveToMouse( TPoint m, uchar selMode );
    void MoveCursorTo(unsigned x, unsigned y);
    int  IsFirstCharInLine(void);
    void GotoOffSet(unsigned o);
    void IndentBlock(unsigned Amount, char Fill, Boolean allowUndo=True);
    void UnIndentBlock(unsigned Amount, Boolean allowUndo=True);
    void BackSpace(Boolean allowUndo=True);
    void ExpandMacro(void);
    int TestPropagation(uint32 OldAttr,uint16 NewAttr,char *proxLine, uint32 proxLineNum);
    int SearchCloseSymbol(char open, char close);
    int SearchCloseSymbolXY(char open, char close, int &X, int &Y);
    int SearchOpenSymbol(char open, char close);
    int SearchOpenSymbolXY(char open, char close, int &X, int &Y);
    Boolean clipReplace(void);
    int GoFirstCharInLine(void);
    void SelWordUnderCursor(void);
    int nextCWord();
    void addToUndo(UndoState st, void *p=NULL);
    void freeUndoCell(int Index);
    void redo(void);
    void UndoSaveFinalState(UndoCell &un);
    void UndoSaveStartState(UndoCell &un);
    void BlockToUpper(Boolean allowUndo);
    void BlockToLower(Boolean allowUndo);
    int  AdjustBufEditFor(int lar);
    void Beep(void);
    void AdjustLineSel(uint32 pos,int dif,Boolean IncludeStart=False,Boolean toLeft=True);
    void AdjustDrawPtr(void);
    void updateCrossCur(void);
    void setStatusLine(char *s);
    void RecalculateXofLineInEdit(void);
    Boolean hasRectSel(void) { return Boolean(!selRectHided && Xr1<Xr2 && Yr1<=Yr2); };
    unsigned GetOffSetOffLine(int y);
    int EnsureXDontTab(char *s,int x,int w,char **stop);
    void lockUndo(void) { undoLockCount++; };
    void unlockUndo(void);
    void SetSpecialLines(int *a) { SpecialLines=a; };

    LineLengthArray lenLines; // pseudo-Array with all the line-lengths
    uint32 totalLines;        // Total number of lines
    uint32 drawLine;          // first displayed line
    uint32 lineInEdition;     // Line number in edition process
    char  *curLinePtr;        // Pointer to the start of the line where the
                              // cursor is.
    char  *bufEdit;           // Buffer to edit a line
    uint16 bufEditLen;        // Allocated memory for bufEdit
    char  *inEditPtr;         // Pointer to the cursor inside the line edition
                              // buffer
    Boolean IslineInEdition;  // There is a line under edition?
    TPoint curPos;            // Position of cursor inside the file
    int    restCharsInLine;   // Number of chars between inEditPtr and the end
                              // of the buffer.
    unsigned selLineStart;    // selStart in a line
    unsigned selLineEnd;      // selEnd in a line
    unsigned selNewStart;     // The value of selXXX when the line in edition
    unsigned selNewEnd;       // will be put in the buffer
    Boolean  selHided;       // True if the selection is invisible
    uint32 selStartOffSet;   // The start of a selecting operation
    unsigned Markers[10];    // 0=does't exist != It's a marker
    int MarkersInLine[10];   // -1 Isn't in this line other offset in the line
    unsigned attrInEdit;     // Attributes for the line in edition
    Boolean NotExpandingMacro; // False if we are expanding a pseudo macro to
                               // avoid an alteration of the selected area
    uchar   ForceSelection;    // Force to set this selecting mode instead
                               // of use the shifts in handleEvent

    UndoCell UndoArray[MAX_UNDO];    // Array with the undo info
    UndoState UndoSt;                // Actual State
    int UndoBase,UndoActual,UndoTop; // Index in the array

    // a pointer to the function to format the line to be displayed.
    void (TCEditor::*formatLinePtr)(void *, unsigned, int, unsigned short, unsigned, unsigned short, unsigned );
    // a pointer to the function to format calculate the s. hl. attributes
    uint16 (*LineMeassure)(char *, char *, uint16 &);
    shlState SyntaxHL;  /* Says the type of syntax highlight used */

    // Macro, I don't know if this will used really
    Boolean Recording;
    uint16  MacroArray[32];
    int     MacroCount;

    static unsigned LoadingVersion;   // That's the version of the desktop file opened
                             // Is here to comunicate the value between the
                             // ::read functions

    // CrossCursor
    Boolean CrossCursorInCol,CrossCursorInRow;
    static Boolean staticCrossCursorInCol;
    static Boolean staticCrossCursorInRow;
    int CrossCursorCol,CrossCursorRow;
    char CrossCursorBuf[setMaxScreenY];
    char CrossCursorBufR[setMaxScreenX];
    int CrossCursorY2,CrossCursorX2;
    Boolean CrossCurInCacheC,CrossCurInCacheR;

    // Status Line
    Boolean IsStatusLineOn;
    static char StatusLine[setMaxScreenX*2];

    // New search options
    static ushort SearchInSel;
    static ushort FromWhere;
    unsigned StartOfSearch;
    unsigned selStartF,selEndF;
    Boolean IsFoundOn;

    // Highligth of one char
    int XHLC,YHLC,XHLCo,YHLCo;
    Boolean IsHLCOn;
    char OldHLAttr,OldHLAttro;

    // Rectangular selection
    int Xr1,Yr1,Xr2,Yr2;     // Start and end point of the rect. sel
    Boolean selRectHided;    // To hide the sel
    struct selRecSt *selRectClip;

    // Groups of undo
    int undoLockCount;
    int undoGroupCount;

    // To keep track of the position of some line
    int *SpecialLines;

    // If 1 the colors are allready cached
    static int colorsCached;

private:

    virtual const char *streamableName() const
	{ return name; }

protected:

    TCEditor( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TCEditor& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TCEditor*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TCEditor& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TCEditor* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TCEditor

#if defined( Uses_TCFileEditor ) && !defined( __TCFileEditor )
#define __TCFileEditor

#include <dir.h>

class far TRect;
class far TScrollBar;
class far TIndicator;
class far TEvent;

class TCFileEditor : public TCEditor
{

public:

    char fileName[MAXPATH];
    TCFileEditor( const TRect&,
		 TScrollBar *,
		 TScrollBar *,
		 TIndicator *,
		 const char *
	       );
    virtual void doneBuffer();
    virtual void handleEvent( TEvent& );
    virtual void initBuffer();
    Boolean loadFile();
    Boolean save();
    Boolean saveAs();
    Boolean saveFile(Boolean Unix=False);
    Boolean saveAsUNIX();
    virtual Boolean setBufSize( uint32 );
    virtual void shutDown();
    virtual void updateCommands();
    virtual Boolean valid( ushort );

private:

    static const char * near backupExt;

    virtual const char *streamableName() const
	{ return name; }

protected:

    TCFileEditor( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TCFileEditor& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TCFileEditor*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TCFileEditor& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TCFileEditor* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TCFileEditor

#if defined( Uses_TCEditWindow ) && !defined( __TCEditWindow )
#define __TCEditWindow

class far TCFileEditor;

class TCEditWindow : public TWindow
{

public:

    TCEditWindow( const TRect&, const char *, int );
    //TCEditWindow( const TRect&,TCFileEditor *, int aNumber );
    virtual void close();
    virtual const char *getTitle( short );
    virtual void handleEvent( TEvent& );
    virtual void sizeLimits( TPoint& min, TPoint& max );
    virtual TPalette& getPalette() const;

    TCFileEditor *editor;

private:

    static const char * near clipboardTitle;
    static const char * near untitled;

    virtual const char *streamableName() const
	{ return name; }

protected:

    TCEditWindow( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TCEditWindow& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TCEditWindow*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TCEditWindow& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TCEditWindow* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TCEditWindow


