#include <dos.h>
#include <dpmi.h>
#include <sys/farptr.h>
#include <go32.h>

#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)

unsigned short getshiftstate(void)
{
  return _farpeekw(_dos_ds,0x417);
}

unsigned short gkey(void)
{
  REGS r;
  r.h.ah = 0x10;
  INTR(0x16,r);
#ifndef NO_TRANS
// At first handle the num pad
  switch (r.x.ax) {
#define K(_x,_y) case _x: r.x.ax = _y; break;
K(0x5230,0x0B30)
K(0x4F31,0x0231)
K(0x5032,0x0332)
K(0x5133,0x0433)
K(0x4B34,0x0534)
K(0x4C35,0x0635)
K(0x4D36,0x0736)
K(0x4737,0x0837)
K(0x4838,0x0938)
K(0x4939,0x0A39)
K(0x532C,0x332C)
K(0xE00D,0x1C0D)
K(0x4E2B,0x1B2B)
K(0x4A2D,0x352D)
K(0x372A,0x1B2A)
K(0xE02F,0x082F)
#undef K
  }
  if (r.h.al == 0xE0 || r.h.al == 0) r.h.al = 0;
  unsigned short S = getshiftstate();
  switch (r.h.ah)
  {
    case 0x39: if (S & 0x0008) r.x.ax = 0x0200; break; // kbAltSpace
    case 0x92: if ((S & 0x0004) && (S & 0x0003))
                 {
                  r.x.ax = 0x0410;
                  break; // kbCtrlShiftIns
                 }
               if (S & 0x0004)
                  r.h.ah = 0x04;
               break; // kbCtrlIns
    case 0x52: if (S & 0x0003) r.h.ah = 0x05;   break; // kbShiftIns
    case 0x93: if ((S & 0x0004) && (S & 0x0003))
                 {
                  r.x.ax = 0x0610;
                  break; // kbCtrlShiftDel
                 }
               if (S & 0x0004)
                  r.h.ah = 0x06;
               break; // kbCtrlDel
    case 0x53: if (S & 0x0003) r.h.ah = 0x07;   break; // kbShiftDel
  }
#endif
  return r.x.ax;
}
  
#ifdef TEST
#include <stdio.h>
main()
{
  unsigned short key;
  do
  {
    key = gkey();
    fprintf(stdout,"%04X\n",key);
  } while (1);
}
#endif
