#if defined( Uses_TFileViewer ) && !defined( __TFileViewer )
#define __TFileViewer

#include <tv.h>

const hlChangeDir = cmChangeDir;

const unsigned short cmFileViewAnswer = 599; // I hope this conflicts with
                                             // nothing else

class TLineCollection : public TCollection
{

public:

    TLineCollection(ccIndex lim, ccIndex delta) : TCollection(lim, delta) {}
    virtual void  freeItem(void *p) { delete p; }

private:

    virtual void *readItem( ipstream& ) { return 0; }
    virtual void writeItem( void *, opstream& ) {}

    friend class TFileViewer;

};

class TFileViewer : public TScroller
{

public:

    char *fileName;
    Boolean isValid;
    TFileViewer( const TRect& bounds,
                 TScrollBar *aHScrollBar,
                 TScrollBar *aVScrollBar,
                 const char *aFileName
               );
    ~TFileViewer();
    TFileViewer( StreamableInit ) : TScroller(streamableInit) { };
    void draw();
    void readFile( const char *fName );
    virtual void saveFile(const char *fName);
    virtual void handleEvent(TEvent &);
    void setState( ushort aState, Boolean enable );
    void scrollDraw();
    virtual void changeBounds(const TRect &);
    Boolean valid( ushort command );
    void insertLine(const char *line);
    const char * const operator [] (int index);
    int Count() { return count; }

private:

/* I have moved the fileLines in the private section, because
   I'm using now a faster way for the FileViewer in which the user
   is not allowed to insert or delete a line from the fileLines.
   For inserting a line use the TFileViewer::insertLine.
   For accessing the lines use TFileViewer::operator []
*/
    TLineCollection *fileLines;
    virtual const char *streamableName() const
        { return name; }

    char *buffer;
    int real_bufsize;

protected:

    const char * const getBuffer() { return buffer; }
    int getBufsize() { return real_bufsize; }

    virtual void write( opstream& );
    virtual void *read( ipstream& );

    int width;
    int count;

public:

    static const char * const name;
    static TStreamable *build();

};

class TFileWindow : public TWindow
{

public:

    TFileWindow( const char *fileName );

};

#endif

