#if defined( Uses_TResourceCollection ) && !defined( __TResourceCollection )
#define __TResourceCollection

class TResourceCollection: public TStringCollection
{

public:

    TResourceCollection( StreamableInit) : TStringCollection( streamableInit ) {};
    TResourceCollection( ccIndex aLimit, ccIndex aDelta );

    virtual void *keyOf( void *item );

private:

    virtual void freeItem( void *item );

    virtual const char *streamableName() const
	{ return name; }
    virtual void *readItem( ipstream& );
    virtual void writeItem( void *, opstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TResourceCollection& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TResourceCollection*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TResourceCollection& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TResourceCollection* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TResourceCollection

