/* ---------------------------------------------------------------------- */
/*      class TFrame                                                      */
/*                                                                        */
/*      Palette layout                                                    */
/*        1 = Passive frame                                               */
/*        2 = Passive title                                               */
/*        3 = Active frame                                                */
/*        4 = Active title                                                */
/*        5 = Icons                                                       */
/* ---------------------------------------------------------------------- */

#if defined( Uses_TFrame ) && !defined( __TFrame )
#define __TFrame

class far TRect;
class far TEvent;
class far TDrawBuffer;

class TFrame : public TView
{

public:

    TFrame( const TRect& bounds );

    virtual void draw();
    virtual TPalette& getPalette() const;
    virtual void handleEvent( TEvent& event );
    virtual void setState( ushort aState, Boolean enable );

private:

    void frameLine( TDrawBuffer& frameBuf, short y, short n, uchar color );
    void dragWindow( TEvent& event, uchar dragMode );

    friend class TDisplay;
    static const char near initFrame[19];
    static char near frameChars[33];
    static const char * near closeIcon;
    static const char * near zoomIcon;
    static const char * near unZoomIcon;
    static const char * near dragIcon;

    virtual const char *streamableName() const
	{ return name; }

protected:

    TFrame( StreamableInit );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TFrame& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TFrame*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TFrame& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TFrame* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TFrame

