#if defined( Uses_TFileDialog ) && !defined( __TFileDialog )
#define __TFileDialog

const ushort
    fdOKButton      = 0x0001,      // Put an OK button in the dialog
    fdOpenButton    = 0x0002,      // Put an Open button in the dialog
    fdReplaceButton = 0x0004,      // Put a Replace button in the dialog
    fdClearButton   = 0x0008,      // Put a Clear button in the dialog
    fdHelpButton    = 0x0010,      // Put a Help button in the dialog
    fdNoLoadDir     = 0x0100;      // Do not load the current directory
				   // contents into the dialog at Init.
				   // This means you intend to change the
				   // WildCard by using SetData or store
				   // the dialog on a stream.

class far TEvent;
class far TFileInputLine;
class far TFileList;

class TFileDialog : public TDialog
{

public:

    TFileDialog( const char *aWildCard, const char *aTitle,
		 const char *inputName, ushort aOptions, uchar histId );
    ~TFileDialog();

    virtual void getData( void *rec );
    void getFileName( char *s );
    virtual void handleEvent( TEvent& event );
    virtual void setData( void *rec );
    virtual Boolean valid( ushort command );
    virtual void shutDown();

    TFileInputLine *fileName;
    TFileList *fileList;
#ifndef USE_LFN
    char wildCard[MAXPATH];
#else
    char wildCard[MAXLFNPATH];
#endif
    const char *directory;

private:

    void readDirectory();

    Boolean checkDirectory( const char * );

    virtual const char *streamableName() const
	{ return name; }

protected:

    TFileDialog( StreamableInit ) : TDialog ( streamableInit ),
	TWindowInit( &TFileDialog::initFrame ) {}
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TFileDialog& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TFileDialog*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TFileDialog& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TFileDialog* cl )
    { return os << (TStreamable *)cl; }

#endif  // Uses_TFileDialog

