#if defined( Uses_TColorDialog ) && !defined( __TColorDialog )
#define __TColorDialog

class far TColorGroup;
class far TEvent;
class far TColorDisplay;
class far TColorGroupList;
class far TLabel;
class far TColorSelector;
class far TMonoSelector;
class far TPalette;

class TColorDialog : public TDialog
{

public:

    TColorDialog( TPalette *aPalette, TColorGroup *aGroups );
    ~TColorDialog();
    virtual uint32 dataSize();
    virtual void getData( void *rec );
    virtual void handleEvent( TEvent& event );
    virtual void setData( void *rec);

    TPalette *pal;

protected:

    TColorDisplay *display;
    TColorGroupList *groups;
    TLabel *forLabel;
    TColorSelector *forSel;
    TLabel *bakLabel;
    TColorSelector *bakSel;
    TLabel *monoLabel;
    TMonoSelector *monoSel;

private:

    
    virtual const char *streamableName() const
        { return name; }

protected:

    TColorDialog( StreamableInit );
    virtual void write( opstream& );
    virtual void *read( ipstream& );

public:

    static const char * const near name;
    static TStreamable *build();

};

inline ipstream& operator >> ( ipstream& is, TColorDialog& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TColorDialog*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TColorDialog& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TColorDialog* cl )
    { return os << (TStreamable *)cl; }

#endif  // TColorDialog

