#define Uses_TDrawBuffer
#define Uses_TSystemError
#define Uses_TScreen
#include <tv.h>

#include <dos.h>
#include <bios.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <go32.h>
#include <dpmi.h>

#if defined( DJGPP ) && ( DJGPP > 1 )
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)
#else
#define REGS union REGS
#define INTR(nr,r) int86(nr,&r,&r)
#endif

Boolean near TSystemError::ctrlBreakHit = False;
short ( far * near TSystemError::sysErrorFunc )( short, uchar ) = &TSystemError::sysErr;
ushort near TSystemError::sysColorAttr = 0x4E4F;
ushort near TSystemError::sysMonoAttr = 0x7070;
Boolean near TSystemError::saveCtrlBreak = False;
Boolean near TSystemError::sysErrActive = False;
Boolean near TSystemError::inIDE = False;

const SecretWord = 1495;
const productID  =  136;

#define INT(nr) INTR(nr,r)

#ifdef USE_SYSERR
static REGS r;
#endif

#define ES (r.x.es)
#define AL (r.h.al)
#define BL (r.h.bl)
#define AX (r.x.ax)
#define BX (r.x.bx)
#define CX (r.x.cx)
#define DX (r.x.dx)

#ifdef USE_SYSERR
static void checkIDE()
{
    Int11trap trap;
    BX = SecretWord;
    AX = SecretWord;
    INT( 0x12 );
}
#endif

TSystemError::TSystemError()
{
#ifdef USE_SYSERR
    inIDE = False;
    checkIDE();
    resume();
#endif
}

TSystemError::~TSystemError()
{
#ifdef USE_SYSERR
    suspend();
#endif
}

#ifdef USE_SYSERR
static int getakey()
{
    if (bioskey(1)==0) return 0;
    return bioskey(0);
}
#endif

ushort TSystemError::selectKey()
{
#ifdef USE_SYSERR
    ushort crsrType = TScreen::getCursorType();

    TScreen::setCursorType( 0x2000 );

    while( getakey() )
	;

    int ch = getakey() & 0xFF;
    while( ch != 13 && ch != 27 )
	ch = getakey() & 0xFF;

    TScreen::setCursorType( crsrType );
    return ch == 27;
#else
  return 1;
#endif
}

#ifdef USE_SYSERR
short TSystemError::sysErr( short errorCode, uchar drive )
{
    ushort c = ( (TScreen::screenMode & 0x00fF) != TDisplay::smMono  ) ?
					sysColorAttr : sysMonoAttr;
    char s[ 63 ];
    TDrawBuffer b;

    sprintf( s, errorString[ errorCode ], drive + 'a' );

    b.moveChar( 0, ' ', c, 80);
    b.moveCStr( 1, s, c);
    b.moveCStr( 79-cstrlen(sRetryOrCancel), sRetryOrCancel, c);
    swapStatusLine(b);
    int res = selectKey();
    swapStatusLine(b);
    return res;
}
#else
short TSystemError::sysErr( short, uchar )
{
  return 0;
}
#endif

#ifdef USE_SYSERR
static _go32_dpmi_seginfo newhandler,oldhandler;
#endif

Int11trap::Int11trap()
{
#ifdef USE_SYSERR
    _go32_dpmi_get_protected_mode_interrupt_vector(0x11, &oldhandler);
    newhandler.pm_offset = (int)Int11trap::handler;
    newhandler.pm_selector = _go32_my_cs();
    _go32_dpmi_chain_protected_mode_interrupt_vector(0x11, &newhandler);
#endif
}

Int11trap::~Int11trap()
{
#ifdef USE_SYSERR
    _go32_dpmi_set_protected_mode_interrupt_vector(0x11, &oldhandler);
#endif
}

void Int11trap::handler(...)
{
#ifdef USE_SYSERR
    ushort ax,bx;
    asm("movw %%ax,%0\n
         movw %%bx,%1"
       : "=g" (ax),
         "=g" (bx));
    if( ax == SecretWord && bx == productID )
	TSystemError::inIDE = True;
#endif
}

void interrupt (far * near Int11trap::oldHandler)(...) = 0;

const char * const near TSystemError::errorString[14] = {
#ifdef USE_SYSERR
  "Critical disk error on drive %s",
  "Disk is write-protected in drive %c",
  "Disk is not ready in drive %s",
  "Data integrity error on drive %c",
  "Seek error on drive %c",
  "Unknown media type in drive %c",
  "Sector not found on drive %c",
  "Printer out of paper",
  "Write fault on drive %c",
  "Read fault on drive %c",
  "Hardware failure on drive %c",
  "Bad memory image of FAT detected",
  "Device access error",
  "Insert diskette in drive %c"
#else
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  "",
  ""
#endif
};

const char * near TSystemError::sRetryOrCancel =
#ifdef USE_SYSERR
"~Enter~ Retry  ~Esc~ Cancel";
#else
"";
#endif

void TSystemError::suspend()
{
}

void TSystemError::resume()
{
}

#define SCREEN(x) ((ushort *)TScreen::screenBuffer)[x]

#ifdef USE_SYSERR
void TSystemError::swapStatusLine(TDrawBuffer & buf)
{
  int i,ofs=TScreen::screenWidth*(TScreen::screenHeight-1);
  ushort temp;
  for (i=0;i<TScreen::screenWidth;i++)
  {
    temp = SCREEN(ofs);
    SCREEN(ofs) = buf.data[i];
    buf.data[i] = temp;
    ofs++;
  }
}
#else
void TSystemError::swapStatusLine(TDrawBuffer &)
{
}
#endif

