#define Uses_TDirCollection
#define Uses_TDirEntry
#define Uses_opstream
#define Uses_ipstream
#define Uses_TStreamableClass
#include <tv.h>

#include <dir.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>

#include <dos.h>
#include <dpmi.h>
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)

Boolean driveValid( char drive )
{
    REGS r;
    r.x.ax = 0x1C00;
    r.x.dx = toupper(drive) - 'A' + 1;
    INTR(0x21,r);
    if (r.h.al != 0xFF) return True;
    return False;
}

#if 1
extern "C" unsigned short ffattrib(struct ffblk *);
#define A(s) ffattrib(&s)
#else
#define A(s) s.ff_attrib
#endif

Boolean isDir( const char *str )
{
#if 1
  struct stat st;
  stat(str,&st);
  return st.st_mode & S_IFDIR ? True : False;
#else
    ffblk ff;
    return Boolean( findfirst( str, &ff, FA_DIREC ) == 0 &&
                    (A(ff) & FA_DIREC) != 0 );
#endif
}

Boolean pathValid( const char *path )
{
#if 1
  char tmp[MAXPATH];
  _fixpath(path,tmp);
  return isDir(tmp);
#else
    char expPath[MAXLFNPATH];
    strcpy( expPath, path );
    fexpand( expPath );
    int len = strlen(expPath);
    if( len <= 3 )
        return driveValid(expPath[0]);
    if (expPath[1] == ':' && driveValid(expPath[0]) == False)
      return False;
    if( expPath[len-1] == DIRSEPARATOR )
        expPath[len-1] = EOS;

    return isDir( expPath );
#endif
}

Boolean validFileName( const char *fileName )
{
#if 1
#ifdef __MSDOS__
  static const char * const illegalChars = ";,=+<>|\"[]"DIRSEPARATOR_;
#else
  static const char * const illegalChars = "<>|\""DIRSEPARATOR_;
#endif
  const char *slash = strrchr(fileName,'/');
  if (!slash)
  {
    if (strpbrk(fileName,illegalChars) != 0)
      return False;
    return True;
  }
  if (strpbrk(slash+1,illegalChars) != 0)
    return False;
  char *dir = (char *)alloca((int)(slash-fileName)+1);
  strncpy(dir,fileName,(int)(slash-fileName));
  dir[(int)(slash-fileName)] = 0;
  return pathValid(dir);
#else
    static const char * const illegalChars = ";,=+<>|\"[] "DIRSEPARATOR_;
    char path[MAXLFNPATH];
    char dir[MAXLFNPATH];
    char name[MAXLFN];
    char ext[MAXLFN];
    fnsplit( fileName, path, dir, name, ext );
    strcat( path, dir );
    if( *dir != EOS && !pathValid( path ) )
        return False;
    if( strpbrk( name, illegalChars ) != 0 ||
        (*ext != 0 && (
        strpbrk( ext+1, illegalChars) != 0 ||
        strchr( ext+1, '.' ) != 0
        ))
      )
        return False;
    return True;
#endif
}

void getCurDir( char *dir )
{
#if 1    
  getwd(dir);
  if (dir[strlen(dir)-1] != '/')
    strcat(dir,"/");
#else
    dir[0] = getdisk() + 'a';
    dir[1] = ':';
    dir[2] = DIRSEPARATOR;
    getcurdir( 0, dir+3 );
    if( strlen( dir ) > 3 )
	strcat( dir, DIRSEPARATOR_ );
#endif
}

Boolean isWild( const char *f )
{
    return Boolean( strpbrk( f, "?*" ) != 0 );
}

TStreamable *TDirCollection::build()
{
    return new TDirCollection( streamableInit );
}

void TDirCollection::writeItem( void *obj, opstream& os )
{
    TDirEntry *item = (TDirEntry *)obj;
    os.writeString( item->text() );
    os.writeString( item->dir() );
}

void *TDirCollection::readItem( ipstream& is )
{
    const char *txt = is.readString();
    const char *dir = is.readString();
    return new TDirEntry( txt, dir );
}
