/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Uses_TEventQueue
#define Uses_TApplication
#define Uses_TScreen
#define Uses_TDeskTop
#define Uses_TStatusLine
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TKeys
#define Uses_TPalette
#define Uses_MsgBox
#define Uses_TDialog
#define Uses_TSCollection
#define Uses_TMenuBar
#define Uses_TSubMenu
#define Uses_TMenuItem
#define Uses_TFileDialog
#define Uses_TFileInputLine
#define Uses_TEditor // for cmSave

#define Uses_TDirList
#define Uses_TParamList
#define Uses_tvutilFunctions
#define Uses_TWindowList
#include <libtvuti.h>

#define Uses_TWatchListBox
#define Uses_tvgdbCommands
#define Uses_tvgdbFunctions
#include <libtvgdb.h>

#include <librhgdb.h>
#include <stdio.h>
#include "rhgdb.h"
#include <string.h>
#include <stdlib.h>
#include <locale.h>
#include <io.h>
#include <unistd.h>
#include <signal.h>
#include <setjmp.h>
#include <dir.h>
#include <sys/exceptn.h>

char *progname;
TDirList *src_dirs = NULL;
int tabsize = 8;

static void ReadOptions(char *);
static void SaveOptions(char *);

class RHGDBApp : public TApplication
{
public:
  RHGDBApp();
  virtual void handleEvent(TEvent &);
  virtual TPalette & getPalette() const;
  static TMenuBar *initMenuBar(TRect);
  static TStatusLine *initStatusLine(TRect);
};

#include "pal.c"

const char *_cpRHGDBColor = cpRHGDBColor;
const char *_cpRHGDBBlackWhite = cpRHGDBBlackWhite;
const char *_cpRHGDBMono = cpRHGDBMono;
int cpColorSize = sizeof(cpRHGDBColor)-1;
int cpBlackWhiteSize = sizeof(cpRHGDBBlackWhite)-1;
int cpMonoSize = sizeof(cpRHGDBMono)-1;

TPalette & RHGDBApp::getPalette() const
{
  static TPalette color(_cpRHGDBColor,cpColorSize);
  static TPalette bw(_cpRHGDBBlackWhite,cpBlackWhiteSize);
  static TPalette mono(_cpRHGDBMono,cpMonoSize);
  return appPalette == apBlackWhite ? bw :
         appPalette == apMonochrome ? mono : color;
}

RHGDBApp::RHGDBApp() :
  TApplication(),
  TProgInit(RHGDBApp::initStatusLine,
            RHGDBApp::initMenuBar,
            RHGDBApp::initDeskTop)
{
}

TMenuBar *RHGDBApp::initMenuBar(TRect r)
{
  r = TProgram::application->getExtent();
  r.b.y = r.a.y + 1;
  return new TMenuBar(r,
    *new TSubMenu(_("~F~ile"), kbAltF) +
      *new TMenuItem(_("~O~pen"),cmOpen,kbF3,hcNoContext,"F3") +
      *new TMenuItem(_("~Q~uit"),cmQUIT,kbAltX,hcNoContext,"Alt+X") +
           newLine() +
      *new TMenuItem(_("~G~oto Line..."), cmGotoLine, kbNoKey, hcNoContext, "Ctrl+J") +
      *new TMenuItem(_("~J~ump to function"), cmJumpFunction, kbAltF2, hcNoContext, "Alt+F2" ) +
    *new TSubMenu(_("~R~un"),kbAltR) +
      *new TMenuItem( _("~S~tep over"), cmStep, kbF8, hcNoContext, "F8" )+
      *new TMenuItem( _("~T~race into"), cmTrace, kbF7, hcNoContext, "F7" )+
      *new TMenuItem( _("~G~o to cursor"), cmGoto, kbF4, hcNoContext, "F4" )+
      *new TMenuItem( _("~P~rogram reset"), cmReset, kbCtrlF2, hcNoContext, "Ctrl+F2" )+
           newLine() +
      *new TMenuItem( _("~A~rguments ..."), cmProgArgs, kbNoKey, hcNoContext)+
    *new TSubMenu(_("~D~ebug"),kbAltD) +
      *new TMenuItem(_("~S~et/Reset Breakpoint"),cmToggleBreak,kbCtrlF8,hcNoContext,"Ctrl+F8")+
      *new TMenuItem(_("~E~valuate/Modify"),cmEvaluate,kbCtrlF4,hcNoContext,"Ctrl+F4") +
      *new TMenuItem(_("~W~atch an expression"),cmAddWatchEntry,kbCtrlF7,hcNoContext,"Ctrl+F7") +
      *new TMenuItem(_("~B~reakpoints"),cmBreakPoints,kbNoKey,hcNoContext,"") +
      newLine() +
      *new TMenuItem(_("~C~all stack"),cmCallStack,kbCtrlF3,hcNoContext,"Ctrl+F3") +
      *new TMenuItem(_("List of ~F~unctions"), cmFunctionList, kbNoKey, hcNoContext, "") +
    *new TSubMenu(_("~O~ptions"),kbAltO) +
      *new TMenuItem(_("~D~irectories for sources"),cmSrcDirs,kbNoKey,hcNoContext,"") +
      *new TMenuItem(_("~P~references"),cmPreferences,kbNoKey,hcNoContext,"") +
      *new TMenuItem(_("~S~ave options"),cmSaveOptions,kbNoKey,hcNoContext,"") +
      *new TMenuItem(_("~L~oad options"),cmLoadOptions,kbNoKey,hcNoContext,"") +
    *new TSubMenu(_("~W~indows"),kbAltW ) +
      *new TMenuItem(_("~S~ize/move"),cmResize,kbCtrlF5,hcNoContext,"Ctrl+F5") +
      *new TMenuItem(_("~Z~oom"),cmZoom,kbF5,hcNoContext,"F5") +
      *new TMenuItem(_("~N~ext"),cmNext,kbF6,hcNoContext,"F6") +
      *new TMenuItem(_("~P~revious"),cmPrev,kbShiftF6,hcNoContext,"Shift+F6") +
      *new TMenuItem(_("~C~lose"),cmClose,kbAltF3,hcNoContext,"Alt+F3") +
      newLine() +
      *new TMenuItem(_("~U~ser screen"),cmUserScreen,kbAltF5,hcNoContext,"Alt+F5")+
      *new TMenuItem(_("~W~indow list"),cmWindowList,kbAlt0,hcNoContext,"Alt+0")
  );
}

TStatusLine *RHGDBApp::initStatusLine(TRect r)
{
  r = TProgram::application->getExtent();
  r.a.y = r.b.y -1;
  return new TStatusLine(r,
    *new TStatusDef(hcFunctionInputLine,hcFunctionInputLine) +
      *new TStatusItem(_("~Ctrl+F1~ Select from a list"), kbCtrlF1, cmSelectFunction) +
    *new TStatusDef(0,0xFFFF) +
      *new TStatusItem(NULL,kbAltX,cmQUIT) +
      *new TStatusItem(_("~F7~ Trace"),kbF7,cmTrace) +
      *new TStatusItem(_("~F8~ Step"),kbF8,cmStep) +
      *new TStatusItem(_("~F4~ Goto"),kbF4,cmGoto) +
      *new TStatusItem(_("~^F2~ Reset"),kbCtrlF2,cmReset) +
      *new TStatusItem(_("~^F8~ Break"),kbCtrlF8,cmToggleBreak) +
      *new TStatusItem(_("~^F4~ Eval"),kbCtrlF4,cmEvaluate) +
      *new TStatusItem(_("~^F9~ Run"),kbCtrlF9,cmRun) +
      *new TStatusItem(NULL,kbCtrlF7,cmAddWatchEntry) +
      *new TStatusItem(NULL,kbAltF5,cmUserScreen) +
      *new TStatusItem(NULL,kbAlt0,cmWindowList) +
      *new TStatusItem(NULL,kbF10,cmMenu) +
      *new TStatusItem(NULL,kbF2,cmSave)
  );
}

void USERSCREEN();

TParamList *ProgArgs;

void RHGDBApp::handleEvent(TEvent & event)
{
  static char *callstack_name = NULL;
  static Boolean Focus = False;
  if (event.what == evCommand && event.message.command == cmQuit)
    event.message.command = cmQUIT;
  TApplication::handleEvent(event);
  switch (event.what)
  {
    case evBroadcast:
      switch (event.message.command)
      {
        case cmFocusWindow:
          Focus = True;
        case cmOpenWindow:
          string_dup(callstack_name,(char *)event.message.infoPtr);
          clearEvent(event);
          break;
        case cmGotoWindowLine:
          if (!callstack_name) break;
          OpenViewer(callstack_name,event.message.infoInt,False,Focus);
          string_free(callstack_name);
          Focus = False;
          clearEvent(event);
          break;
        default:
          break;
      }
      break;
    case evCommand:
      switch (event.message.command)
      {
        case cmCallStack:
          ShowCallStackWindow();
          clearEvent(event);
          break;
	case cmProgArgs:
	  editParamList(ProgArgs,_("Program arguments"),2);
	  clearEvent(event);
	  break;
        case cmFunctionList:
        {
          char regex[256];
          regex[0] = 0;
          function_entry *func;
          if (inputBox(_("Regular expression to list functions"),
                       _("~E~xpression"),regex,255) == cmOK)
          {
            if (SelectFunction(_("List of functions"),regex,NULL,NULL,&func)
                == cmOK)
            {
              OpenViewer(func->file_name,func->line_number,False);
              CenterCursor();
            }
          }
          clearEvent(event);
          break;
        }
        case cmPreferences:
          Preferences();
          clearEvent(event);
          break;
        case cmSrcDirs:
          SourceDirectories();
          clearEvent(event);
          break;
        case cmBreakPoints:
          BreakDialog();
          repaint();
          clearEvent(event);
          break;
        case cmOpen:
          FileOpen();
          clearEvent(event);
          break;
        case cmSaveOptions:
          SaveOptions();
          clearEvent(event);
          break;
        case cmLoadOptions:
          LoadOptions();
          clearEvent(event);
          break;
        case cmAddWatchEntry:
          AddWatchEntry(RHGDBWordUnderCursor());
          clearEvent(event);
          break;
        case cmEvaluate:
          Evaluate(RHGDBWordUnderCursor());
          clearEvent(event);
          break;
        case cmUserScreen:
          USERSCREEN();
          clearEvent(event);
          break;
        case cmStep:
          STEP();
          clearEvent(event);
          break;
        case cmTrace:
          TRACE();
          clearEvent(event);
          break;
        case cmRun:
          RUN();
          clearEvent(event);
          break;
        case cmGoto:
          GOTO();
          clearEvent(event);
          break;
        case cmReset:
          RESET();
          clearEvent(event);
          break;
        case cmQUIT:
          RESET();
          endModal(cmQuit);
          clearEvent(event);
          break;
        case cmWindowList:
          ShowWindowList(_("All windows on the desktop"));
          clearEvent(event);
          break;
        case cmToggleBreak:
          ToggleBreak();
          repaint();
          clearEvent(event);
          break;
      }
      break;
  }
}

static void UPDATE_WATCH()
{
  if (watchwindow) watches->update();
  UpdateCallStackWindow();
}

static void InitDebuggerInterface();

int main(int argc,char *argv[])
{
  RHGDBApp *app;
  char *main_source = NULL;
  char *locale_dir,localedir[256];
  char *init_name = NULL,initname[256];
  int main_line,i;
  setlocale (LC_ALL, "");
  locale_dir = getenv("LOCALEDIR");
  if (!locale_dir)
  {
    locale_dir = getenv("DJDIR");
    if (locale_dir) strcpy(localedir,locale_dir);
    else localedir[0] = 0;
    strcat(localedir,"/data/locale");
  }
  else
  {
    strcpy(localedir,locale_dir);
  }
  BINDTEXTDOMAIN("rhide",localedir);
  TEXTDOMAIN("rhide");

  src_dirs = new TDirList();
  ProgArgs = new TParamList();
  for (i=1;i<argc;i++)
  {
    if (argv[i][0] != '-')
    {
      progname = argv[i];
      int j;
      for (j=i+1;j<argc;j++)
      {
        ProgArgs->insert(strdup(argv[j]));
      }
      break;
    }
    else
    {
      if (strcmp(argv[i],"-D") == 0)
      {
        TEventQueue::suspend();
        TScreen::suspend();
        dual_display = 1;
        TScreen::resume();
        TEventQueue::resume();
      }
      else
      if (strcmp(argv[i],"-i") == 0)
      {
        i++;
        init_name = argv[i];
      }
      else
      if (strcmp(argv[i],"-G") == 0)
      {
        i++;
        extern int screen_saving;
        TScreen::suspend();
        screen_saving = atoi(argv[i]);
        TScreen::resume();
      }
    }
  }
  if (!progname) return -1;
  app = new RHGDBApp();
  InitDebuggerInterface();
  if (InitRHGDB())
  {
    if (!init_name)
    {
      char drive[256],dir[256],name[256];
      fnsplit(progname,drive,dir,name,NULL);
      strcpy(initname,drive);
      strcat(initname,dir);
      strcat(initname,name);
      strcat(initname,".rgd");
      init_name = initname;
    }
    ReadOptions(init_name);
    main_source = SourceForMain(&main_line);
    if (main_source) OpenViewer(main_source,main_line,False);
    CenterCursor();
  }
  app->run();
  SaveOptions(init_name);
  destroy(app);
  return 0;
}

void STEP()
{
  Step();
}

void TRACE()
{
  Trace();
}

void RESET()
{
  extern void *current_viewer;
  if (!debugger_started)
    return;
  current_viewer = NULL;
  ResetDebugger();
  repaint();
}

void RUN()
{
  Continue();
}

void GOTO()
{
  char *fname,*bname;
  int line,column;
  if ((fname = WhereIsCursor(line,column,bname)) == NULL) return;
  GoToLine(bname,line);
}

void repaint()
{
  TProgram::application->Redraw();
}

void ToggleBreak()
{
  char *fname,*bname;
  int break_number,line,column;
  if ((fname = WhereIsCursor(line,column,bname)) == NULL) return;
  break_number = IsBreakPointLine(bname,line);
  if (break_number >= 0)
    RemoveBreakPoint(break_number);
  else
    AddBreakPointLine(bname,line);
}  

static int DoMake()
{
  return 1;
}

static char *GetProgName()
{
  return progname;
}

static char **GetSourceDirectories(int *count)
{
  *count = 0;
  return NULL;
}

static char **args = NULL; 

static char **GetProgramArguments(int *count)
{
  int i;
  *count = ProgArgs->getCount();
  if (*count == 0) return NULL;
  args = (char **)xrealloc(args,*count * sizeof(char *));
  for (i=0;i<*count;i++)
  {
    args[i] = (char *)ProgArgs->at(i);
  }
  return args;
}

static void UserScreen()
{
  TProgram::application->suspend();
}

static void DebuggerScreen()
{
  TProgram::application->resume();
  repaint();
}

static void select_source_line(char *fname,int line)
{
  if (fname) OpenViewer(fname,line,True);
}

static void EndSession(int exit_code)
{
  messageBox(mfInformation|mfOKButton,
    _("Program exit code: %d (0x%04x)"),exit_code,exit_code);
  repaint();
}

static void BreakSession()
{
}

static void InitDebuggerInterface()
{
  _select_source_line = select_source_line;
  _UserWarning = UserWarning;
  _DebuggerScreen = DebuggerScreen;
  _UserScreen = UserScreen;
  _GetProgramArguments = GetProgramArguments;
  _GetSourceDirectories = GetSourceDirectories;
  _GetProgName = GetProgName;
  _DoMake = DoMake;
  _InitGDBOutWin = InitGDBOutWin;
  _UpdateGDBOutWin = UpdateGDBOutWin;
  _EndSession = EndSession;
  _BreakSession = BreakSession;
  post_command_hook = UPDATE_WATCH;
}

void USERSCREEN()
{
  TEvent event;
  TMouse::hide();
  TScreen::suspend();
  do
  {
    event.getMouseEvent();
    if (event.what == evNothing) event.getKeyEvent();
  } while ((event.what & (evMouseUp | evMouseDown | evKeyDown)) == 0);
  TScreen::resume();
  TMouse::show();
  repaint();
}

long TimeOfFile(const char *,Boolean ,Boolean)
{
  return 0;
}

static char read_buffer[1024];
static FILE *opt_file;

static void WriteIDEOptions()
{
  int i,count;
  fprintf(opt_file,"[IDE]\n");
  fprintf(opt_file,"SCREENMODE: %d\n",TScreen::screenMode);
  count = src_dirs->getCount();
  for (i=0;i<count;i++)
    fprintf(opt_file,"SOURCEDIR: %s\n",(char *)src_dirs->at(i));
  fprintf(opt_file,"TABSIZE: %d\n",tabsize);
  fprintf(opt_file,"VERBOSEGDB: %d\n",verbose_gdb_commands);
  count = ProgArgs->getCount();
  for (i=0;i<count;i++)
  {
    fprintf(opt_file,"ARG: %s\n",(char *)ProgArgs->at(i));
  }
}

static int read_in_buffer()
{
  if (!fgets(read_buffer,1023,opt_file)) return 0;
  if (read_buffer[0]) read_buffer[strlen(read_buffer)-1] = 0;
  return 1;
}

static int key_index(char *key)
{
  int len = strlen(key);
  if (strncmp(read_buffer,key,len) != 0) return 0;
  len++;
  while (read_buffer[len] == ' ') len++;
  return len;
}

static int ReadIDEOptions()
{
  int index,retval;
  int read_args = ProgArgs->getCount();
  while ((retval = read_in_buffer()) && read_buffer[0] != '[')
  {
    if ((index = key_index("SCREENMODE")) != 0)
    {
      int mode;
      sscanf(&read_buffer[index],"%d",&mode);
      TProgram::application->setScreenMode(mode);
      TProgram::application->Redraw();
    }
    else
    if ((index = key_index("ARG")) != 0)
    {
      if (!read_args) // read only if not given on command_line
        ProgArgs->insert(strdup(&read_buffer[index]));
    }
    else
    if ((index = key_index("SOURCEDIR")) != 0)
    {
      src_dirs->insert(strdup(&read_buffer[index]));
    }
    else
    if ((index = key_index("TABSIZE")) != 0)
    {
      sscanf(&read_buffer[index],"%d",&tabsize);
    }
    else
    if ((index = key_index("VERBOSEGDB")) != 0)
    {
      sscanf(&read_buffer[index],"%d",&verbose_gdb_commands);
    }
  }
  return retval;
}

static void WriteBreakPoints()
{
  int count,i;
  BreakPoint *b;
  fprintf(opt_file,"[BREAKPOINTS]\n");
  count = BreakPointCount();
  for (i=0;i<count;i++)
  {
    b = GetBreakPoint(i);
    fprintf(opt_file,"TYPE: %d\n",b->type);
    if (BREAK_LINE(b))
    {
      fprintf(opt_file,"FILE: %s\nLINE: %d\n",b->filename,b->line_number);
    }
    else
    {
      fprintf(opt_file,"FUNCTION: %s\n",b->function);
    }
    if (BREAK_COUNT(b))
    {
      fprintf(opt_file,"COUNT: %d\n",b->count);
    }
    if (BREAK_CONDITION(b))
    {
      fprintf(opt_file,"CONDITION: %s\n",b->condition);
    }
  }
}

#define FREE(x) do {if (x) { free(x); x = NULL; } } while (0)

static int ReadBreakPoints()
{
  int retval,index;
  BreakPoint _bp;
  BreakPoint *bp = &_bp;
  memset(bp,0,sizeof(BreakPoint));
  while ((retval = read_in_buffer()) && read_buffer[0] != '[')
  {
    if ((index = key_index("TYPE")) != 0)
    {
      if (bp->type != 0) EditBreakPoint(bp,-1);
      FREE(bp->function);
      FREE(bp->condition);
      FREE(bp->filename);
      bp->count = 0;
      bp->line_number = 0;
      bp->type = 0;
      int _type;
      sscanf(&read_buffer[index],"%d",&_type);
      bp->type = _type;
    }
    else
    if ((index = key_index("COUNT")) != 0)
    {
      sscanf(&read_buffer[index],"%d",&bp->count);
    }
    else 
    if ((index = key_index("LINE")) != 0)
    {
      sscanf(&read_buffer[index],"%d",&bp->line_number);
    }
    else
    if ((index = key_index("FILE")) != 0)
    {
      bp->filename = strdup(&read_buffer[index]);
    }
    else
    if ((index = key_index("FUNCTION")) != 0)
    {
      bp->function = strdup(&read_buffer[index]);
    }
    else
    if ((index = key_index("CONDITION")) != 0)
    {
      bp->condition = strdup(&read_buffer[index]);
    }
  }
  if (bp->type != 0) EditBreakPoint(bp,-1);
  FREE(bp->function);
  FREE(bp->condition);
  FREE(bp->filename);
  return retval;
}

static void WriteWatches()
{
  int i,count;
  fprintf(opt_file,"[WATCHES]\n");
  count = Watches.getCount();
  for (i=0;i<count;i++)
  {
    fprintf(opt_file,"%s\n",(char *)Watches.at(i));
  }
}

static int ReadWatches()
{
  int retval;
  while ((retval = read_in_buffer()) && read_buffer[0] != '[')
  {
    if (read_buffer[0] != ' ') AddWatch(read_buffer);
  }
  return retval;
}

static void SaveOptions(char *fname)
{
  opt_file = fopen(fname,"w+");
  WriteBreakPoints();
  WriteWatches();
  WriteIDEOptions();
  fclose(opt_file);
}

static void ReadOptions(char *fname)
{
  int not_end;
  opt_file = fopen(fname,"r");
  if (!opt_file) return;
  while ((not_end = read_in_buffer()) && read_buffer[0] != '[');
  while (not_end)
  {
    if (strcmp(read_buffer,"[IDE]") == 0) not_end = ReadIDEOptions();
    else
    if (strcmp(read_buffer,"[WATCHES]") == 0) not_end = ReadWatches();
    else
    if (strcmp(read_buffer,"[BREAKPOINTS]") == 0) not_end = ReadBreakPoints();
    else
    while ((not_end = read_in_buffer()) && read_buffer[0] != '[');
  }
  fclose(opt_file);
}

void SaveOptions()
{
  char fname[256];
  TFileDialog *dialog;
  dialog = new TFileDialog("*.rgd",_("Save options to file"),
                           _("~N~ame"),fdOKButton,0);
  if (TProgram::deskTop->execView(dialog) == cmFileOpen)
  {
    strcpy(fname,dialog->directory);
    strcat(fname,dialog->fileName->data);
    SaveOptions(fname);
  }
  destroy(dialog);
}


void LoadOptions()
{
  char fname[256];
  TFileDialog *dialog;
  dialog = new TFileDialog("*.rgd",_("Read options from file"),
                           _("~N~ame"),fdOpenButton,0);
  if (TProgram::deskTop->execView(dialog) == cmFileOpen)
  {
    strcpy(fname,dialog->directory);
    strcat(fname,dialog->fileName->data);
    ReadOptions(fname);
  }
  destroy(dialog);
}

void FileOpen()
{
  char fname[256];
  TFileDialog *dialog;
  dialog = new TFileDialog("*.*",_("Open a file"),
                          _("~N~ame"),fdOpenButton,0);
  if (TProgram::deskTop->execView(dialog) == cmFileOpen)
  {
    strcpy(fname,dialog->directory);
    strcat(fname,dialog->fileName->data);
    OpenViewer(fname,1,False);
  }
  destroy(dialog);
}

void SourceDirectories()
{
  editDirList(src_dirs,_("Pathlist for source files"),1);
}

const char msg[] =
"RHGDB internal error. Please send a description of this situation\r\n"
"as most as possible detailed to the author together with the version\r\n"
"you are using. AND VERY IMPORTANT IS THE NEXT TRACEBACK!!!!\r\n\r\n";

static jmp_buf abort_jmp;

extern "C" __attribute__ (( __noreturn__ ))
void abort()
{
  // call at least TEventQueue::resume() to clear the mouse hook
  TEventQueue::suspend();
  TScreen::suspend();
  _write(STDERR_FILENO, msg, sizeof(msg)-1);
  setjmp(abort_jmp);
  __djgpp_exception_state_ptr = &abort_jmp;
  raise(SIGABRT);
  _exit(1);
}


