#define Uses_TMemInfo
#include <libtvuti.h>

#include <stdio.h>
#include <dpmi.h>

void TIDEMemInfo::update(int force)
{
  unsigned long _p_mem,_v_mem;
  get_mem_info(_v_mem,_p_mem);
  if (force || _p_mem != p_mem || _v_mem != v_mem)
  {
    v_mem = _v_mem;
    p_mem = _p_mem;
    drawView();
  }
}

static char scale_mem(unsigned long & b)
{
  if (b <= 1024) return 'B';
  b /= 1024;
  if (b <= 1024) return 'K';
  b /= 1024;
  if (b <= 1024) return 'M';
  b /= 1024;
  return 'K';
}

void TIDEMemInfo::draw()
{
  TDrawBuffer b;
  char dummy[80];
  char v=' ',p=' ';
  unsigned long _v_mem = v_mem,_p_mem = p_mem;
  v = scale_mem(_v_mem);
  p = scale_mem(_p_mem);
  uchar c = getColor(2);
  b.moveChar(0, ' ', c, size.x);
  sprintf(dummy,"%ld%c/%ld%c",_v_mem,v,_p_mem,p);
  b.moveStr(0,dummy,c);
  writeLine(0,0,size.x,1,b);
}

void get_mem_info(unsigned long & virt_mem,unsigned long & phys_mem)
{
  _go32_dpmi_meminfo info;
  _go32_dpmi_get_free_memory_information(&info);
  virt_mem = info.available_memory;
  phys_mem = info.available_physical_pages * 4096;
}

