/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
#define Uses_TDialog
#define Uses_TScrollBar
#define Uses_TIDEEditWindow
#define Uses_TMsgCollection
#define Uses_TMsgListBox
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_LangTexte
#define Uses_TWindowList
#include <libide.h>

#define Uses_TSCollection
#define Uses_tvutilFunctions
#include <libtvuti.h>

#include <rhide.h>
#include <string.h>
#include <stdio.h>

TDialog *msg_window = NULL;
TListBox *msg_list = NULL;
TRect MsgWindowRect(-1,-1,-1,-1);

TEditWindow *is_on_desktop(const char * fname,Boolean is_full_name)
{
  int i,count;
  char *name1;
  if (!windows) return NULL;
  count = windows->getCount();
  for (i=0;i<count;i++)
  {
    DeskTopWindow *w = (DeskTopWindow *)windows->at(i);
    if ((is_full_name == True && strcmp(fname,w->full_name)==0)
         || (strcmp(fname,w->base_name)==0))
         return (TEditWindow *)w->window;
  }
  string_dup(name1,fname);
  FExpand(name1);
  for (i=0;i<count;i++)
  {
    DeskTopWindow *w = (DeskTopWindow *)windows->at(i);
    if (strcmp(name1,w->full_name) == 0)
    {
      string_free(name1);
      return (TEditWindow *)w->window;
    }
  }
  string_free(name1);
  return NULL;
}

class TMsgDialog : public TDialog
{
public:
  TMsgDialog(const TRect &r,const char *t) :
    TDialog(r,t),
    TWindowInit(TMsgDialog::initFrame)
  {
  }
  virtual void changeBounds(const TRect &);
};

void TMsgDialog::changeBounds(const TRect &r)
{
  TDialog::changeBounds(r);
  MsgWindowRect = r;
}

void ShowMessages(TMsgCollection *msgs,Boolean remove_old)
{
  TProgram::deskTop->lock();
  if (!msg_window)
  {
    TScrollBar *scrollbar;
    TRect r;
    if (MsgWindowRect.a.x == -1)
    {
      MsgWindowRect = TProgram::deskTop->getExtent();
      MsgWindowRect.a.y = MsgWindowRect.b.y-7;
    }
    msg_window = new TMsgDialog(MsgWindowRect,_("Message Window"));
    msg_window->flags = wfMove | wfGrow | wfZoom | wfClose;
    msg_window->growMode = gfGrowLoY | gfGrowHiX | gfGrowHiY;
    r = msg_window->getExtent();
    r.grow(-1,-1);
    scrollbar = msg_window->standardScrollBar(sbVertical | sbHandleKeyboard);
    msg_list = new TMsgListBox(r,1,scrollbar);
    msg_list->growMode = gfGrowHiX | gfGrowHiY;
    scrollbar = msg_window->standardScrollBar(sbHorizontal | sbHandleKeyboard);
    scrollbar->setParams(0,0,255-(r.b.x-r.a.x),40,1);
    msg_list->hScrollBar = scrollbar;
    msg_window->insert(msg_list);
    AddWindow(msg_window,(TWindow **)&msg_window);
  }
  msg_window->hide();
  if (remove_old==True || msg_list->list() == NULL) msg_list->newList(msgs);
  else
  {
    int i,old=msg_list->list()->getCount();
    if (msgs->getCount() == 0) old--;
    for (i=0;i<msgs->getCount();i++)
    {
      msg_list->list()->insert(msgs->at(i));
    }
    msgs->removeAll();
    destroy(msgs);
    msg_list->setRange(msg_list->list()->getCount());
    msg_list->focusItem(old);
    msg_list->drawView();
  }
  if (msg_list->list() != NULL && msg_list->list()->getCount()>0)
  {
    if (msg_list->hScrollBar) msg_list->hScrollBar->setValue(0);
    msg_window->show();
    msg_window->select();
  }
  TProgram::deskTop->unlock();
}


