/* decomp.cof -> decomp.h */

#include <stdio.h>

#ifdef  __DJGPP__
#include <crt0.h>
char ** __crt0_glob_function (char *arg) { return (char **)NULL; }
void    __crt0_load_environment_file (char *app_name) {}
void    __crt0_setup_arguments (void) {}
#endif  /* __DJGPP__ */

int main (void)
{
    unsigned char buf [8192];
    FILE          *f1,*f2;
    int           ic,jc;
    
    if ((f1=fopen ("decomp.cof","rb"))==NULL)
        return 1;
    if ((f2=fopen ("decomp.h","wt"))==NULL)
        return 2;

    if ((ic=fread (buf,1,8192,f1)) < 512)
        return 3;

    for (jc=ic-2; jc>0xa8; jc--)
        if (buf[jc]=='M' && buf[jc+1]=='L')
            break;
    if (jc==0xa8)
        return 4;

    for (ic=0xa8; ic<((jc+3)&~3)-1; ic++)
        fprintf (f2,"0x%02x,%s",buf[ic],ic%14==13 ? "\n" : "");
    fprintf (f2,"0x%02x",buf[ic]);
    return 0;
}