/*----------------------------------------------------------------------------
 
              // /-----/ /-----/ /------/ /------/ /------/ /-/   /-/
             // / /----/ / /---/ / /----/ / /----/ / /--/ /  / /  / /
            / / / /--/   / /--/   / /--/   / /--/   / /--/ /   / / / /
       // / / / /--/   / /--/   / /--/   / /--/   / /----/    / // /
     / /-/ / / /----/ / /      / /      / /----/ / / /-/   /----/ /
    /------/ /------/ /-/      /-/      /------/ /-/   /-/ /------/

This program has been programmed by Jeffery Guan. If there is any comments,
mail your e-mail to jgfw@usa.net. If you want snail mail, mail it to the
following address

    18, SS 17/1H,
    Subang Jaya,
    47500 Petaling Jaya,
    Selangor Darul Ehsan,
    Malaysia.

This program is the simplified version of Mikmod.c and it uses allegro's
timer functions.

-------------------------------------------------------------------------------*/

#include "mikmod.h"     // always include allegro.h after mikmod.h
#include "allegro.h"    // Otherwise you will get the message EOF
                        // redefined during compiling

void update(void)
{
    MD_Update();        // need to be call frequently to update the music
}
END_OF_FUNCTION(update);

void tickhandler(void)
{
	MP_HandleTick();    /* play 1 tick of the module */
	MD_SetBPM(mp_bpm);
}

void main(void)
{
    UNIMOD *mf;
    setvbuf(stdout, NULL, _IONBF, 0);

//  Initialize soundcard parameters.. you _have_ to do this
//  before calling MD_Init(), and it's illegal to change them
//  after you've called MD_Init()

	md_mixfreq      =44100;                     /* standard mixing freq */
    md_dmabufsize   =2000;                     /* standard dma buf size */
	md_mode         =DMODE_16BITS|DMODE_STEREO; /* standard mixing mode */
	md_device       =0;                                                     /* standard device: autodetect */
    
    ML_RegisterLoader(&load_s3m);   // Register the loaders we want to use..

    MD_RegisterDriver(&drv_nos);    // Register the drivers we want to use:
	MD_RegisterDriver(&drv_ss);
	MD_RegisterDriver(&drv_sb);
	MD_RegisterDriver(&drv_gus);

    MD_RegisterPlayer(tickhandler);

    allegro_init();     // initialize allegro
    install_timer();    // install the timer module
    LOCK_FUNCTION(update);

    if(!MD_Init())  // initialize soundcard 
        {
		printf("Driver error: %s.\n",myerr);
        exit (0);
        }
    
    mf=ML_LoadFN("7th.s3m");    // load the the music. If it didn't work,
    if(mf==NULL)                // exit with errormsg
        {
        printf("MikMod Error: %s\n",myerr);
        exit (0);
        }

    printf("\nUsing %s for %d bit %s %s sound at %u Hz\n\n",
			md_driver->Name,
			(md_mode&DMODE_16BITS) ? 16:8,
			(md_mode&DMODE_INTERP) ? "interpolated":"normal",
			(md_mode&DMODE_STEREO) ? "stereo":"mono",
			md_mixfreq);

    MP_Init(mf);            // initialize modplayer to play this module

    printf( "Songname: %s\n"
            "Modtype : %s\n"
            "Periods : %s,%s\n\n",
            mf->songname,
            mf->modtype,
            (mf->flags&UF_XMPERIODS) ? "XM type" : "mod type",
            (mf->flags&UF_LINEAR) ? "Linear" : "Log");

    md_numchn=mf->numchn;   // set the number of voices to use.. you
                            // could add extra channels here (e.g. md_numchn=mf->numchn+4; )
                            // to use for your own soundeffects:

    MD_PlayStart();         // start playing the music

    install_int (update, 10);

    while ( !kbhit() && !MP_Ready() )
        printf("\rsngpos:%d patpos:%d sngspd %d bpm %d   ",mp_sngpos,mp_patpos,mp_sngspd,mp_bpm);

    printf ("\n");
    MD_PlayStop();              // stop playing
    ML_Free(mf);                // and free the module
    MD_Exit(); 
}


